/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncoderUtil {
    private static final Logger logger = LoggerFactory.getLogger(EncoderUtil.class);
    private static final String DEFAULT_STRING_ENCODING = "UTF-8";

    private EncoderUtil() {
    }

    public static String urlEncode(String value) {
        return EncoderUtil.urlEncode(value, DEFAULT_STRING_ENCODING);
    }

    public static String urlEncode(String value, String encoding) {
        try {
            if (value == null) {
                return "";
            }
            if (StringUtils.isBlank((String)value)) {
                return value;
            }
            return URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String htmlEncode(String s) {
        return StringEscapeUtils.escapeHtml((String)s);
    }

    public static String uriEncode(String uri) {
        int length = uri.length();
        if (length == 0) {
            return uri;
        }
        StringBuffer results = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            char c = uri.charAt(i);
            switch (c) {
                case ' ': 
                case '\"': 
                case '$': 
                case '%': 
                case '&': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': {
                    try {
                        byte[] octets = uri.substring(i, i + 1).getBytes();
                        for (int j = 0; j < octets.length; ++j) {
                            String hexVal = Integer.toHexString(octets[j]).toUpperCase();
                            if (hexVal.length() == 2) {
                                results.append("%").append(hexVal);
                                continue;
                            }
                            results.append("%0").append(hexVal);
                        }
                        continue block5;
                    }
                    catch (Exception e) {
                        continue block5;
                    }
                }
                default: {
                    results.append(c);
                }
            }
        }
        return results.toString();
    }

    public static String xmlEncode(String s) {
        return StringEscapeUtils.escapeXml((String)s);
    }
}

