/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.util;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggingUtils.class);

    private LoggingUtils() {
    }

    public static void logRequestHeaders(HttpServletRequest request) {
        LoggingUtils.logRequestHeaders(logger, request);
    }

    public static void logRequestHeaders(Logger logger, HttpServletRequest request) {
        if (logger.isDebugEnabled()) {
            Enumeration enumeration = request.getHeaderNames();
            StringBuffer logLine = new StringBuffer();
            logLine.append("Request Headers");
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String headerValue = request.getHeader(name);
                logLine.append(": ").append(name).append(" -> ").append(headerValue);
            }
            logger.debug(logLine.toString());
        }
    }
}

