/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.web;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.lib.util.LoggingUtils;

public final class RequestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestUtils.class);

    private RequestUtils() {
    }

    public static boolean isIncluded(HttpServletRequest request) {
        boolean includeRequest;
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        boolean bl = includeRequest = uri != null;
        if (includeRequest && logger.isDebugEnabled()) {
            logger.debug(request.getRequestURL() + " resulted in an include request. This is unusable, because" + "the response will be assembled into the overrall response. Not gzipping.");
        }
        return includeRequest;
    }

    public static boolean acceptsGzipEncoding(HttpServletRequest request) {
        return RequestUtils.acceptsEncoding(request, "gzip");
    }

    public static boolean acceptsEncoding(HttpServletRequest request, String name) {
        boolean accepts = RequestUtils.headerContains(request, "Accept-Encoding", name);
        return accepts;
    }

    public static boolean headerContains(HttpServletRequest request, String header, String value) {
        LoggingUtils.logRequestHeaders(logger, request);
        Enumeration accepted = request.getHeaders(header);
        while (accepted.hasMoreElements()) {
            String headerValue = (String)accepted.nextElement();
            if (headerValue.indexOf(value) == -1) continue;
            return true;
        }
        return false;
    }

    public static String resolveUserIpAddress(HttpServletRequest request) {
        String endUserIp = request.getHeader("X-Forwarded-For");
        String[] ips = StringUtils.split((String)endUserIp, (String)",");
        endUserIp = ips != null && ips.length > 0 ? ips[ips.length - 1] : request.getRemoteAddr();
        return endUserIp.trim();
    }
}

