/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.lib.web.ResponseHeadersNotModifiableException;

public final class ResponseUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResponseUtils.class);
    private static final int EMPTY_GZIPPED_CONTENT_SIZE = 20;

    private ResponseUtils() {
    }

    public static boolean shouldGzippedBodyBeZero(byte[] compressedBytes, HttpServletRequest request) {
        if (compressedBytes.length == 20) {
            if (logger.isDebugEnabled()) {
                logger.debug(request.getRequestURL() + " resulted in an empty response.");
            }
            return true;
        }
        return false;
    }

    public static boolean shouldBodyBeZero(HttpServletRequest request, int responseStatus) {
        if (responseStatus == 204) {
            if (logger.isDebugEnabled()) {
                logger.debug(request.getRequestURL() + " resulted in a " + 204 + " response. Removing message body in accordance with RFC2616.");
            }
            return true;
        }
        if (responseStatus == 304) {
            if (logger.isDebugEnabled()) {
                logger.debug(request.getRequestURL() + " resulted in a " + 304 + " response. Removing message body in accordance with RFC2616.");
            }
            return true;
        }
        return false;
    }

    public static void addGzipHeader(HttpServletResponse response) throws ResponseHeadersNotModifiableException {
        response.setHeader("Content-Encoding", "gzip");
        boolean containsEncoding = response.containsHeader("Content-Encoding");
        if (!containsEncoding) {
            throw new ResponseHeadersNotModifiableException("Failure when attempting to set Content-Encoding: gzip");
        }
    }
}

