/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.lib.web.GenericResponseWrapper;
import org.yestech.lib.web.RequestUtils;
import org.yestech.lib.web.ResponseUtils;

public class CompressionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(CompressionFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest rawRequest, ServletResponse rawResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)rawRequest;
        HttpServletResponse response = (HttpServletResponse)rawResponse;
        if (!RequestUtils.isIncluded(request) && RequestUtils.acceptsEncoding(request, "gzip")) {
            if (logger.isDebugEnabled()) {
                logger.debug(request.getRequestURL() + ". Writing with gzip compression");
            }
            ByteArrayOutputStream compressed = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(compressed);
            GenericResponseWrapper wrapper = new GenericResponseWrapper(response, gzout);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
            wrapper.flush();
            gzout.close();
            int statusCode = wrapper.getStatus();
            if (statusCode != 200) {
                return;
            }
            byte[] compressedBytes = compressed.toByteArray();
            boolean shouldGzippedBodyBeZero = ResponseUtils.shouldGzippedBodyBeZero(compressedBytes, request);
            boolean shouldBodyBeZero = ResponseUtils.shouldBodyBeZero(request, wrapper.getStatus());
            if (shouldGzippedBodyBeZero || shouldBodyBeZero) {
                compressedBytes = new byte[]{};
            }
            ResponseUtils.addGzipHeader(response);
            response.setContentLength(compressedBytes.length);
            response.getOutputStream().write(compressedBytes);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug(request.getRequestURL() + ". Writing without gzip compression because the request does not accept gzip.");
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }
}

