/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpToHttpsSendRedirectFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, (ServletResponse)new SendRedirectOverloadedResponse((HttpServletRequest)request, (HttpServletResponse)response));
    }

    private static class SendRedirectOverloadedResponse
    extends HttpServletResponseWrapper {
        private static final Logger logger = LoggerFactory.getLogger(SendRedirectOverloadedResponse.class);
        private String prefix = null;

        private SendRedirectOverloadedResponse(HttpServletRequest inRequest, HttpServletResponse response) {
            super(response);
            this.prefix = this.getPrefix(inRequest);
        }

        public void sendRedirect(String location) throws IOException {
            if (logger.isInfoEnabled()) {
                logger.info("Going originally to:" + location);
            }
            String finalurl = null;
            if (this.isUrlAbsolute(location)) {
                if (logger.isInfoEnabled()) {
                    logger.info("This url is absolute. No scheme changes will be attempted");
                }
                finalurl = location;
            } else {
                finalurl = this.fixForScheme(this.prefix + location);
                if (logger.isInfoEnabled()) {
                    logger.info("Going to absolute url:" + finalurl);
                }
            }
            super.sendRedirect(finalurl);
        }

        public boolean isUrlAbsolute(String url) {
            String lowercaseurl = url.toLowerCase();
            return lowercaseurl.startsWith("http");
        }

        public String fixForScheme(String url) {
            return url;
        }

        public String getPrefix(HttpServletRequest request) {
            StringBuffer str = request.getRequestURL();
            String url = str.toString();
            String uri = request.getRequestURI();
            if (logger.isInfoEnabled()) {
                logger.info("requesturl:" + url);
                logger.info("uri:" + uri);
            }
            int offset = url.indexOf(uri);
            String prefix = url.substring(0, offset);
            if (logger.isInfoEnabled()) {
                logger.info("prefix:" + prefix);
            }
            return prefix;
        }
    }
}

