/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.lib.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(XmlUtils.class);
    private static final XStream cachedStream = new XStream(){

        protected MapperWrapper wrapMapper(MapperWrapper next) {
            return new MapperWrapper((Mapper)next){

                public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                    return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                }
            };
        }
    };
    private static final XStream cachedJsonStream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver()){

        protected MapperWrapper wrapMapper(MapperWrapper next) {
            return new MapperWrapper((Mapper)next){

                public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                    return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                }
            };
        }
    };

    public static void dump(XMLStreamReader reader, Logger callbackLogger) {
        if (logger.isDebugEnabled()) {
            callbackLogger.debug("\nXML Dump Results: \n" + XmlUtils.parse(reader) + "\n");
        }
    }

    public static String toXmlJaxb(Object object) {
        String result = "";
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshal(object, (Writer)writer);
            result = writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String toXml(Object object) {
        return XmlUtils.toXml(object, false);
    }

    public static String toXml(Object object, boolean annotation) {
        String result = "";
        if (object != null) {
            if (annotation) {
                XStream stream = new XStream(){

                    protected MapperWrapper wrapMapper(MapperWrapper next) {
                        return new MapperWrapper((Mapper)next){

                            public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                                return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                            }
                        };
                    }
                };
                stream.autodetectAnnotations(annotation);
                stream.setMode(1001);
                result = stream.toXML(object);
            } else {
                cachedStream.setMode(1001);
                result = cachedStream.toXML(object);
            }
        }
        return result;
    }

    public static String toXml(List<?> list, String listName) {
        return XmlUtils.toXml(list, listName, false);
    }

    public static String toXml(List<?> list, String listName, boolean annotation) {
        String result = "";
        if (list != null) {
            if (annotation) {
                XStream stream = new XStream(){

                    protected MapperWrapper wrapMapper(MapperWrapper next) {
                        return new MapperWrapper((Mapper)next){

                            public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                                return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                            }
                        };
                    }
                };
                stream.autodetectAnnotations(annotation);
                stream.setMode(1001);
                stream.alias(listName, List.class);
                result = stream.toXML(list);
            } else {
                cachedStream.setMode(1001);
                cachedStream.alias(listName, List.class);
                result = cachedStream.toXML(list);
            }
        }
        return result;
    }

    public static String toJSon(Object object) {
        return XmlUtils.toJSon(object, false);
    }

    public static String toJSon(Object object, boolean annotation) {
        String result = "";
        if (object != null) {
            if (annotation) {
                XStream stream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver()){

                    protected MapperWrapper wrapMapper(MapperWrapper next) {
                        return new MapperWrapper((Mapper)next){

                            public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                                return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                            }
                        };
                    }
                };
                stream.autodetectAnnotations(annotation);
                stream.setMode(1001);
                result = stream.toXML(object);
            } else {
                cachedJsonStream.setMode(1001);
                result = cachedJsonStream.toXML(object);
            }
        }
        return result;
    }

    public static String toPartialXml(Object object, Map<String, Class<?>> omit) {
        return XmlUtils.toPartialXml(object, omit, false);
    }

    public static String toPartialXml(Object object, Map<String, Class<?>> omit, boolean annotation) {
        String result = "";
        if (object != null && omit != null) {
            XStream stream = new XStream(){

                protected MapperWrapper wrapMapper(MapperWrapper next) {
                    return new MapperWrapper((Mapper)next){

                        public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                            return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                        }
                    };
                }
            };
            stream.setMode(1001);
            stream.autodetectAnnotations(annotation);
            Iterator<Map.Entry<String, Class<?>>> i$ = omit.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, Class<?>> stringClassEntry;
                Map.Entry<String, Class<?>> alias = stringClassEntry = i$.next();
                stream.omitField(alias.getValue(), alias.getKey());
            }
            result = stream.toXML(object);
        }
        return result;
    }

    public static String toXml(Object object, Map<String, Class<?>> aliases) {
        return XmlUtils.toXml(object, aliases, false);
    }

    public static String toXml(Object object, Map<String, Class<?>> aliases, boolean annotation) {
        String result = "";
        if (object != null && aliases != null) {
            if (annotation) {
                XStream stream = new XStream(){

                    protected MapperWrapper wrapMapper(MapperWrapper next) {
                        return new MapperWrapper((Mapper)next){

                            public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                                return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                            }
                        };
                    }
                };
                stream.autodetectAnnotations(annotation);
                stream.setMode(1001);
                Iterator<Map.Entry<String, Class<?>>> i$ = aliases.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<String, Class<?>> stringClassEntry;
                    Map.Entry<String, Class<?>> alias = stringClassEntry = i$.next();
                    stream.alias(alias.getKey(), alias.getValue());
                }
                result = stream.toXML(object);
            } else {
                cachedStream.setMode(1001);
                Iterator<Map.Entry<String, Class<?>>> i$ = aliases.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<String, Class<?>> stringClassEntry;
                    Map.Entry<String, Class<?>> alias = stringClassEntry = i$.next();
                    cachedStream.alias(alias.getKey(), alias.getValue());
                }
                result = cachedStream.toXML(object);
            }
        }
        return result;
    }

    public static String toPartialXml(Object object, Map<String, Class<?>> aliases, Map<String, Class<?>> omit) {
        return XmlUtils.toPartialXml(object, aliases, omit, false);
    }

    public static String toPartialXml(Object object, Map<String, Class<?>> aliases, Map<String, Class<?>> omit, boolean annotation) {
        Map.Entry<String, Class<?>> alias;
        Map.Entry<String, Class<?>> stringClassEntry;
        Iterator<Map.Entry<String, Class<?>>> i$;
        String result = "";
        XStream stream = new XStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                    }
                };
            }
        };
        stream.autodetectAnnotations(annotation);
        stream.setMode(1001);
        if (object != null && aliases != null) {
            i$ = aliases.entrySet().iterator();
            while (i$.hasNext()) {
                alias = stringClassEntry = i$.next();
                stream.alias(alias.getKey(), alias.getValue());
            }
        }
        if (object != null && omit != null) {
            i$ = omit.entrySet().iterator();
            while (i$.hasNext()) {
                alias = stringClassEntry = i$.next();
                stream.omitField(alias.getValue(), alias.getKey());
            }
        }
        if (object != null) {
            result = stream.toXML(object);
        }
        return result;
    }

    public static <T> T fromJSon(String json) {
        return XmlUtils.fromJSon(json, false);
    }

    public static <T> T fromJSon(String json, boolean annotation) {
        Object result = "";
        if (StringUtils.isNotBlank((String)json)) {
            if (annotation) {
                XStream stream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver()){

                    protected MapperWrapper wrapMapper(MapperWrapper next) {
                        return new MapperWrapper((Mapper)next){

                            public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                                return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                            }
                        };
                    }
                };
                stream.autodetectAnnotations(annotation);
                stream.setMode(1001);
                result = stream.fromXML(json);
            } else {
                cachedJsonStream.setMode(1001);
                result = cachedJsonStream.fromXML(json);
            }
        }
        return (T)result;
    }

    public static <T> T fromXml(String xml) {
        return XmlUtils.fromXml(xml, false);
    }

    public static <T> T fromXml(String xml, boolean annotation) {
        Object result = "";
        if (StringUtils.isNotBlank((String)xml)) {
            if (annotation) {
                XStream stream = new XStream(){

                    protected MapperWrapper wrapMapper(MapperWrapper next) {
                        return new MapperWrapper((Mapper)next){

                            public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                                return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                            }
                        };
                    }
                };
                stream.autodetectAnnotations(annotation);
                stream.setMode(1001);
                result = stream.fromXML(xml);
            } else {
                cachedStream.setMode(1001);
                result = cachedStream.fromXML(xml);
            }
        }
        return (T)result;
    }

    public static <T> T fromXmlJaxb(Object result, String xml) {
        return XmlUtils.fromXmlJaxb(result.getClass(), xml);
    }

    public static <T> T fromXmlJaxb(Class resultClass, String xml) {
        Object result = null;
        if (StringUtils.isNotBlank((String)xml)) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{resultClass});
                Unmarshaller marshaller = jaxbContext.createUnmarshaller();
                result = marshaller.unmarshal((Reader)new StringReader(xml));
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)result;
    }

    public static <T> T fromXml(String xml, Map<String, Class<?>> aliases) {
        return XmlUtils.fromXml(xml, aliases, false);
    }

    public static <T> T fromXml(String xml, Map<String, Class<?>> aliases, boolean annotation) {
        Object result = "";
        if (StringUtils.isNotBlank((String)xml) && aliases != null) {
            if (annotation) {
                XStream stream = new XStream(){

                    protected MapperWrapper wrapMapper(MapperWrapper next) {
                        return new MapperWrapper((Mapper)next){

                            public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                                return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                            }
                        };
                    }
                };
                stream.autodetectAnnotations(annotation);
                stream.setMode(1001);
                Iterator<Map.Entry<String, Class<?>>> i$ = aliases.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<String, Class<?>> stringClassEntry;
                    Map.Entry<String, Class<?>> alias = stringClassEntry = i$.next();
                    stream.alias(alias.getKey(), alias.getValue());
                }
                result = stream.fromXML(xml);
            } else {
                cachedStream.setMode(1001);
                Iterator<Map.Entry<String, Class<?>>> i$ = aliases.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<String, Class<?>> stringClassEntry;
                    Map.Entry<String, Class<?>> alias = stringClassEntry = i$.next();
                    cachedStream.alias(alias.getKey(), alias.getValue());
                }
                result = cachedStream.fromXML(xml);
            }
        }
        return (T)result;
    }

    public static void dump(XMLStreamReader reader) {
        XmlUtils.dump(reader, logger);
    }

    public static String parse(XMLStreamReader reader) {
        StringBuffer result = new StringBuffer();
        if (reader != null) {
            try {
                while (reader.hasNext()) {
                    switch (reader.getEventType()) {
                        case 1: {
                            result.append("<");
                            XmlUtils.printName(reader, result);
                            XmlUtils.printNamespaces(reader, result);
                            XmlUtils.printAttributes(reader, result);
                            result.append(">");
                            break;
                        }
                        case 2: {
                            result.append("</");
                            XmlUtils.printName(reader, result);
                            result.append(">");
                            break;
                        }
                        case 4: 
                        case 6: {
                            int start = reader.getTextStart();
                            int length = reader.getTextLength();
                            result.append(new String(reader.getTextCharacters(), start, length));
                            break;
                        }
                        case 3: {
                            result.append("<?");
                            if (reader.hasText()) {
                                result.append(reader.getText());
                            }
                            result.append("?>");
                            break;
                        }
                        case 12: {
                            result.append("<![CDATA[");
                            int start = reader.getTextStart();
                            int length = reader.getTextLength();
                            result.append(new String(reader.getTextCharacters(), start, length));
                            result.append("]]>");
                            break;
                        }
                        case 5: {
                            result.append("<!--");
                            if (reader.hasText()) {
                                result.append(reader.getText());
                            }
                            result.append("-->");
                            break;
                        }
                        case 9: {
                            result.append(reader.getLocalName()).append("=");
                            if (!reader.hasText()) break;
                            result.append("[").append(reader.getText()).append("]");
                            break;
                        }
                        case 7: {
                            result.append("<?xml");
                            result.append(" version='").append(reader.getVersion()).append("'");
                            result.append(" encoding='").append(reader.getCharacterEncodingScheme()).append("'");
                            if (reader.isStandalone()) {
                                result.append(" standalone='yes'");
                            } else {
                                result.append(" standalone='no'");
                            }
                            result.append("?>");
                        }
                    }
                    reader.next();
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {}
            }
        }
        return result.toString();
    }

    private static void printName(XMLStreamReader xmlr, StringBuffer result) {
        if (xmlr.hasName()) {
            String prefix = xmlr.getPrefix();
            String uri = xmlr.getNamespaceURI();
            String localName = xmlr.getLocalName();
            XmlUtils.printName(prefix, uri, localName, result);
        }
    }

    private static void printName(String prefix, String uri, String localName, StringBuffer result) {
        if (uri != null && !"".equals(uri)) {
            result.append("['").append(uri).append("']:");
        }
        if (prefix != null) {
            result.append(prefix).append(":");
        }
        if (localName != null) {
            result.append(localName);
        }
    }

    private static void printAttributes(XMLStreamReader xmlr, StringBuffer result) {
        for (int i = 0; i < xmlr.getAttributeCount(); ++i) {
            XmlUtils.printAttribute(xmlr, i, result);
        }
    }

    private static void printAttribute(XMLStreamReader xmlr, int index, StringBuffer result) {
        String prefix = xmlr.getAttributePrefix(index);
        String namespace = xmlr.getAttributeNamespace(index);
        String localName = xmlr.getAttributeLocalName(index);
        String value = xmlr.getAttributeValue(index);
        result.append(" ");
        XmlUtils.printName(prefix, namespace, localName, result);
        result.append("='").append(value).append("'");
    }

    private static void printNamespaces(XMLStreamReader xmlr, StringBuffer result) {
        for (int i = 0; i < xmlr.getNamespaceCount(); ++i) {
            XmlUtils.printNamespace(xmlr, i, result);
        }
    }

    private static void printNamespace(XMLStreamReader xmlr, int index, StringBuffer result) {
        String prefix = xmlr.getNamespacePrefix(index);
        String uri = xmlr.getNamespaceURI(index);
        result.append(" ");
        if (prefix == null) {
            result.append("xmlns='").append(uri).append("'");
        } else {
            result.append("xmlns:").append(prefix).append("='").append(uri).append("'");
        }
    }
}

