/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.client;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.publish.client.IPublishBridge;
import org.yestech.publish.objectmodel.ArtifactType;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.IArtifactMetaData;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.service.IPublishProducer;

public class PublishBridge
implements IPublishBridge {
    private static final Logger logger = LoggerFactory.getLogger(PublishBridge.class);
    private Map<ArtifactType, IPublishProducer> producers = new HashMap<ArtifactType, IPublishProducer>();

    @Override
    public Map<ArtifactType, IPublishProducer> getProducers() {
        return this.producers;
    }

    @Override
    public void setProducers(Map<ArtifactType, IPublishProducer> producers) {
        this.producers = producers;
    }

    private IPublishProducer getProducer(IArtifactMetaData metaData) {
        return this.producers.get((Object)metaData.getArtifactType());
    }

    @Override
    public void publish(IArtifact artifact) {
        IPublishProducer producer = this.getProducer((IArtifactMetaData)artifact.getArtifactMetaData());
        producer.send(artifact);
    }

    @Override
    public void publish(IFileArtifact artifact) {
        IPublishProducer producer = this.getProducer((IArtifactMetaData)artifact.getArtifactMetaData());
        producer.send(artifact);
    }
}

