/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jets3t.service.Constants;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.lib.util.Pair;
import org.yestech.publish.objectmodel.ArtifactType;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.objectmodel.IFileArtifactMetaData;
import org.yestech.publish.objectmodel.ProducerArtifactType;
import org.yestech.publish.objectmodel.PublisherProperties;
import org.yestech.publish.publisher.BasePublisher;
import org.yestech.publish.publisher.IPublisher;
import org.yestech.publish.util.PublishUtils;

@ProducerArtifactType(type={ArtifactType.IMAGE, ArtifactType.VIDEO, ArtifactType.TEXT, ArtifactType.AUDIO})
public class AmazonS3Publisher
extends BasePublisher
implements IPublisher<IFileArtifact> {
    private static final Logger logger = LoggerFactory.getLogger(AmazonS3Publisher.class);
    private AWSCredentials awsCredentials;
    private S3Service s3Service;
    private S3Bucket artifactBucket;
    private static final String HTTP_SEPARATOR = "/";
    private PublisherProperties properties = new PublisherProperties();
    private ArtifactType artifactType;

    public File getTempDirectory() {
        return (File)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"tempDirectory"));
    }

    public PublisherProperties getProperties() {
        return this.properties;
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    @Required
    public void setArtifactType(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }

    @Required
    public void setProperties(PublisherProperties properties) {
        this.properties = properties;
    }

    private String getUrlPrefix() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"urlPrefix"));
    }

    public String getAccessKey() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"accessKey"));
    }

    public String getBucketName() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"bucketName"));
    }

    public String getSecretKey() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"secretKey"));
    }

    public S3Service getS3Service() {
        return this.s3Service;
    }

    public void setS3Service(S3Service s3Service) {
        this.s3Service = s3Service;
    }

    @PostConstruct
    public void init() {
        try {
            this.awsCredentials = new AWSCredentials(this.getAccessKey(), this.getSecretKey());
            this.s3Service = new RestS3Service(this.awsCredentials);
            S3Bucket[] myBuckets = this.s3Service.listAllBuckets();
            if (logger.isDebugEnabled()) {
                logger.debug("How many buckets to I have in S3? " + myBuckets.length);
            }
            boolean createNewBucket = true;
            for (S3Bucket bucket : myBuckets) {
                if (!StringUtils.equals((String)this.getBucketName(), (String)bucket.getName())) continue;
                this.artifactBucket = bucket;
                createNewBucket = false;
                break;
            }
            if (createNewBucket) {
                this.artifactBucket = this.s3Service.createBucket(this.getBucketName());
                this.setACLOnBucket();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Created test bucket: " + this.artifactBucket.getName());
            }
        }
        catch (S3ServiceException e) {
            logger.error("Error initializing Amazon S3 Publisher...", (Throwable)e);
        }
    }

    private void setACLOnBucket() throws S3ServiceException {
        AccessControlList bucketAcl = this.s3Service.getBucketAcl(this.artifactBucket);
        bucketAcl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, Permission.PERMISSION_READ);
        this.artifactBucket.setAcl(bucketAcl);
        this.s3Service.putBucketAcl(this.artifactBucket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(IFileArtifact artifact) {
        String fileName;
        String path;
        Object metaData = artifact.getArtifactMetaData();
        InputStream artifactStream = artifact.getStream();
        String artifactDirectoryName = PublishUtils.generateUniqueIdentifier(metaData.getArtifactOwner());
        String uniqueFileName = PublishUtils.generateUniqueIdentifier(metaData);
        Pair<String, String> names = metaData.getUniqueNames();
        if (names != null && StringUtils.isNotBlank((String)(path = (String)names.getFirst()))) {
            artifactDirectoryName = path;
        }
        if (names != null && StringUtils.isNotBlank((String)(fileName = (String)names.getSecond()))) {
            uniqueFileName = fileName;
        }
        String tempFileFqn = this.saveToDisk(artifactDirectoryName, artifactStream, uniqueFileName);
        try {
            StringBuilder s3LocationBuilder = new StringBuilder();
            String s3Location = s3LocationBuilder.append(artifactDirectoryName).append(Constants.FILE_PATH_DELIM).append(uniqueFileName).toString();
            S3Object s3Artifact = new S3Object(s3Location);
            s3Artifact.setContentLength(metaData.getSize());
            s3Artifact.setContentType(metaData.getMimeType());
            s3Artifact.setMd5Hash(ServiceUtils.computeMD5Hash((InputStream)new FileInputStream(new File(tempFileFqn))));
            s3Artifact.setDataInputStream((InputStream)new FileInputStream(new File(tempFileFqn)));
            this.setCredentials(s3Artifact);
            this.s3Service.putObject(this.artifactBucket, s3Artifact);
            this.setFinalLocationInMetaData((IFileArtifactMetaData)metaData, artifactDirectoryName, uniqueFileName);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            File uploadedFile;
            if (logger.isInfoEnabled()) {
                logger.info("removing file: " + tempFileFqn);
            }
            if ((uploadedFile = new File(tempFileFqn)).exists()) {
                uploadedFile.delete();
            }
            PublishUtils.reset(artifact);
        }
    }

    private void setCredentials(S3Object s3Artifact) {
        s3Artifact.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
    }

    private void setFinalLocationInMetaData(IFileArtifactMetaData metaData, String artifactDirectoryName, String uniqueFileName) {
        String defaultLocation = metaData.getLocation();
        if (StringUtils.isBlank((String)defaultLocation)) {
            StringBuilder builder = new StringBuilder();
            String location = builder.append(this.getUrlPrefix()).append(HTTP_SEPARATOR).append(artifactDirectoryName).append(HTTP_SEPARATOR).append(uniqueFileName).toString();
            metaData.setLocation(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveToDisk(String artifactDirectoryName, InputStream artifact, String uniqueFileName) {
        FileOutputStream outputStream;
        String location;
        block6: {
            File fullPath = new File(this.getTempDirectory() + File.separator + artifactDirectoryName);
            if (!fullPath.exists()) {
                fullPath.mkdirs();
            }
            location = fullPath.getAbsolutePath() + File.separator + uniqueFileName;
            outputStream = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Saving file: " + location);
                }
                outputStream = FileUtils.openOutputStream((File)new File(location));
                IOUtils.copyLarge((InputStream)artifact, (OutputStream)outputStream);
                outputStream.flush();
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Saved file: " + location);
            }
            catch (IOException e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)artifact);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)artifact);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)artifact);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return location;
    }
}

