/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.publisher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.lib.util.Pair;
import org.yestech.publish.objectmodel.ArtifactType;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.objectmodel.IFileArtifactMetaData;
import org.yestech.publish.objectmodel.ProducerArtifactType;
import org.yestech.publish.objectmodel.PublisherProperties;
import org.yestech.publish.publisher.BasePublisher;
import org.yestech.publish.publisher.IPublisher;
import org.yestech.publish.publisher.webdav.MkColMethod;
import org.yestech.publish.util.PublishUtils;

@ProducerArtifactType(type={ArtifactType.IMAGE, ArtifactType.VIDEO, ArtifactType.TEXT, ArtifactType.AUDIO})
public class BitgravityWebdavPublisher
extends BasePublisher
implements IPublisher<IFileArtifact> {
    private static final Logger logger = LoggerFactory.getLogger(BitgravityWebdavPublisher.class);
    private static final String HTTP_SEPARATOR = "/";
    private PublisherProperties properties = new PublisherProperties();
    private ArtifactType artifactType;

    @Override
    public void publish(IFileArtifact artifact) {
        String uniqueFileName;
        Object metaData = artifact.getArtifactMetaData();
        InputStream artifactStream = artifact.getStream();
        String artifactDirectoryName = (String)metaData.getUniqueNames().getFirst();
        if (StringUtils.isBlank((String)artifactDirectoryName)) {
            artifactDirectoryName = PublishUtils.generateUniqueIdentifier(metaData.getArtifactOwner());
        }
        if (StringUtils.isBlank((String)(uniqueFileName = (String)metaData.getUniqueNames().getSecond()))) {
            uniqueFileName = PublishUtils.generateUniqueIdentifier(metaData);
        }
        String tempFileFqn = this.saveToDisk(artifactDirectoryName, artifactStream, uniqueFileName);
        try {
            HttpClient client = new HttpClient();
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.getUsername(), this.getPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
            MkColMethod mkColMethod = new MkColMethod(this.getDirectoryPublishUrl(artifactDirectoryName));
            client.executeMethod((HttpMethod)mkColMethod);
            PutMethod putMethod = new PutMethod(this.getFilePublishUrl(artifactDirectoryName, uniqueFileName));
            InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)new BufferedInputStream(new FileInputStream(tempFileFqn)));
            putMethod.setRequestEntity((RequestEntity)requestEntity);
            client.executeMethod((HttpMethod)putMethod);
            putMethod.releaseConnection();
            logger.debug(putMethod.getStatusCode() + " " + putMethod.getStatusText());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            File uploadedFile;
            if (logger.isInfoEnabled()) {
                logger.info("removing file: " + tempFileFqn);
            }
            if ((uploadedFile = new File(tempFileFqn)).exists()) {
                uploadedFile.delete();
            }
            PublishUtils.reset(artifact);
        }
    }

    protected void setLocation(IFileArtifactMetaData metaData, String artifactDirectoryName, String uniqueFileName) {
        String defaultLocation = metaData.getLocation();
        if (StringUtils.isBlank((String)defaultLocation)) {
            StringBuilder builder = new StringBuilder();
            String location = builder.append(this.getUrlPrefix()).append(HTTP_SEPARATOR).append(artifactDirectoryName).append(HTTP_SEPARATOR).append(uniqueFileName).toString();
            metaData.setLocation(location);
        }
    }

    protected String getFilePublishUrl(String artifactDirectoryName, String uniqueFileName) {
        return this.getWebDavPrefix() + HTTP_SEPARATOR + artifactDirectoryName + HTTP_SEPARATOR + uniqueFileName;
    }

    protected String getDirectoryPublishUrl(String artifactDirectoryName) {
        return this.getWebDavPrefix() + HTTP_SEPARATOR + artifactDirectoryName;
    }

    @Required
    public void setArtifactType(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }

    @Required
    public void setProperties(PublisherProperties properties) {
        this.properties = properties;
    }

    public String getUrlPrefix() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"urlPrefix"));
    }

    public String getUsername() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"username"));
    }

    public String getPassword() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"password"));
    }

    public String getWebDavPrefix() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"webDavPrefix"));
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public File getTempDirectory() {
        return (File)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"tempDirectory"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveToDisk(String artifactDirectoryName, InputStream artifact, String uniqueFileName) {
        FileOutputStream outputStream;
        String location;
        block6: {
            File fullPath = new File(this.getTempDirectory() + File.separator + artifactDirectoryName);
            if (!fullPath.exists()) {
                fullPath.mkdirs();
            }
            location = fullPath.getAbsolutePath() + File.separator + uniqueFileName;
            outputStream = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Saving file: " + location);
                }
                outputStream = FileUtils.openOutputStream((File)new File(location));
                IOUtils.copyLarge((InputStream)artifact, (OutputStream)outputStream);
                outputStream.flush();
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Saved file: " + location);
            }
            catch (IOException e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)artifact);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)artifact);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)artifact);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return location;
    }
}

