/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.publisher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.episodic.DefaultEpisodicService;
import org.yestech.episodic.EpisodicService;
import org.yestech.lib.util.Pair;
import org.yestech.publish.objectmodel.ArtifactType;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.objectmodel.ProducerArtifactType;
import org.yestech.publish.objectmodel.PublisherProperties;
import org.yestech.publish.objectmodel.episodic.IEpisodicArtifact;
import org.yestech.publish.objectmodel.episodic.IEpisodicArtifactPersister;
import org.yestech.publish.publisher.BasePublisher;
import org.yestech.publish.publisher.IPublisher;
import org.yestech.publish.util.PublishUtils;

@ProducerArtifactType(type={ArtifactType.VIDEO})
public class EpisodicPublisher
extends BasePublisher
implements IPublisher<IFileArtifact> {
    private static final Logger logger = LoggerFactory.getLogger(EpisodicPublisher.class);
    private PublisherProperties properties = new PublisherProperties();
    private ArtifactType artifactType;
    private IEpisodicArtifactPersister persister;

    @Override
    public void publish(IFileArtifact artifact) {
        String uniqueFileName;
        if (logger.isDebugEnabled()) {
            logger.debug("EpisodicPublisher called for " + artifact);
        }
        Object metaData = artifact.getArtifactMetaData();
        InputStream artifactStream = artifact.getStream();
        String artifactDirectoryName = (String)metaData.getUniqueNames().getFirst();
        if (StringUtils.isBlank((String)artifactDirectoryName)) {
            artifactDirectoryName = PublishUtils.generateUniqueIdentifier(metaData.getArtifactOwner());
        }
        if (StringUtils.isBlank((String)(uniqueFileName = (String)metaData.getUniqueNames().getSecond()))) {
            uniqueFileName = PublishUtils.generateUniqueIdentifier(metaData);
        }
        File tempFile = this.saveToDisk(artifactDirectoryName, artifactStream, uniqueFileName);
        try {
            EpisodicService episodicService = this.buildEpisodicService();
            String assetId = episodicService.createAsset(this.getShowId(), uniqueFileName, tempFile, new String[0]);
            if (assetId != null || !"".equals(assetId)) {
                String episodeId = episodicService.createEpisode(this.getShowId(), uniqueFileName, new String[]{assetId}, true, null, this.getPingUrl(), new String[0]);
                if (metaData instanceof IEpisodicArtifact) {
                    IEpisodicArtifact ea = (IEpisodicArtifact)metaData;
                    ea.setAssetId(assetId);
                    ea.setEpisodeId(episodeId);
                    if (this.persister != null) {
                        this.persister.save(ea);
                    } else {
                        logger.warn("Artifact is an IEpisodicArtfact, but no IEpisodicArtifactPersister was supplied.");
                    }
                }
            }
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info("removing file: " + tempFile);
            }
            if (tempFile.exists()) {
                tempFile.delete();
            }
            PublishUtils.reset(artifact);
        }
    }

    @Required
    public void setArtifactType(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }

    @Required
    public void setProperties(PublisherProperties properties) {
        this.properties = properties;
    }

    public void setPersister(IEpisodicArtifactPersister persister) {
        this.persister = persister;
    }

    public String getSecret() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"secret"));
    }

    public String getApiKey() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"api_key"));
    }

    public String getShowId() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"show_id"));
    }

    public String getPingUrl() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"ping_url"));
    }

    public String proxyHost() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"proxy_host"));
    }

    public String proxyPort() {
        return (String)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"proxy_port"));
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public File getTempDirectory() {
        return (File)this.properties.getProperty((Pair<ArtifactType, String>)Pair.create((Object)((Object)this.getArtifactType()), (Object)"tempDirectory"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveToDisk(String artifactDirectoryName, InputStream artifact, String uniqueFileName) {
        File fullPath = new File(this.getTempDirectory() + File.separator + artifactDirectoryName);
        if (!fullPath.exists()) {
            fullPath.mkdirs();
        }
        File location = new File(fullPath.getAbsolutePath(), uniqueFileName);
        FileOutputStream outputStream = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Saving file: " + location);
            }
            outputStream = FileUtils.openOutputStream((File)location);
            IOUtils.copyLarge((InputStream)artifact, (OutputStream)outputStream);
            outputStream.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Saved file: " + location);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifact);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return location;
    }

    protected EpisodicService buildEpisodicService() {
        String proxyHost = this.proxyHost();
        String proxyPort = this.proxyPort();
        if (proxyHost != null && proxyPort != null) {
            return new DefaultEpisodicService(this.getSecret(), this.getApiKey(), proxyHost, Integer.parseInt(proxyPort));
        }
        return new DefaultEpisodicService(this.getSecret(), this.getApiKey());
    }
}

