/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.publisher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.lib.util.Pair;
import org.yestech.publish.objectmodel.ArtifactType;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.objectmodel.ProducerArtifactType;
import org.yestech.publish.publisher.BasePublisher;
import org.yestech.publish.publisher.IPublisher;
import org.yestech.publish.util.PublishUtils;

@ProducerArtifactType(type={ArtifactType.IMAGE, ArtifactType.VIDEO, ArtifactType.TEXT, ArtifactType.AUDIO})
public class LocalFileSystemPublisher
extends BasePublisher
implements IPublisher<IFileArtifact> {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileSystemPublisher.class);
    private File directory;

    public File getDirectory() {
        return this.directory;
    }

    @Required
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(IFileArtifact artifact) {
        FileOutputStream outputStream;
        String location;
        InputStream artifactStream;
        Object metaData;
        block9: {
            String fileName;
            File fullPath;
            String path;
            metaData = artifact.getArtifactMetaData();
            artifactStream = artifact.getStream();
            Pair<String, String> names = metaData.getUniqueNames();
            String uniquePath = PublishUtils.generateUniqueIdentifier(metaData.getArtifactOwner());
            if (names != null && StringUtils.isNotBlank((String)(path = (String)names.getFirst()))) {
                uniquePath = path;
            }
            if (!(fullPath = new File(this.directory + File.separator + uniquePath)).exists()) {
                fullPath.mkdirs();
            }
            String uniqueFileName = PublishUtils.generateUniqueIdentifier(metaData);
            if (names != null && StringUtils.isNotBlank((String)(fileName = (String)names.getSecond()))) {
                uniqueFileName = fileName;
            }
            location = fullPath.getAbsolutePath() + File.separator + uniqueFileName;
            outputStream = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Saving file: " + location);
                }
                outputStream = FileUtils.openOutputStream((File)new File(location));
                IOUtils.copyLarge((InputStream)artifactStream, (OutputStream)outputStream);
                outputStream.flush();
                if (!logger.isDebugEnabled()) break block9;
                logger.debug("Saved file: " + location);
            }
            catch (IOException e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)artifactStream);
                    IOUtils.closeQuietly(outputStream);
                    PublishUtils.reset(artifact);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)artifactStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                PublishUtils.reset(artifact);
            }
        }
        IOUtils.closeQuietly((InputStream)artifactStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        PublishUtils.reset(artifact);
        if (StringUtils.isBlank((String)metaData.getLocation())) {
            metaData.setLocation(location);
        }
    }
}

