/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.service;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.service.IPublishProducer;
import org.yestech.publish.util.PublishUtils;

public class CamelPublishProducer
implements IPublishProducer {
    private CamelContext context;
    private String startEndPoint;
    private String url;

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Required
    public void setContext(CamelContext context) {
        this.context = context;
    }

    public String getStartEndPoint() {
        return this.startEndPoint;
    }

    @Required
    public void setStartEndPoint(String startEndPoint) {
        this.startEndPoint = startEndPoint;
    }

    @Override
    public void send(IArtifact artifact) {
        DefaultProducerTemplate template = (DefaultProducerTemplate)this.context.createProducerTemplate();
        Endpoint endpoint = this.context.getEndpoint(this.startEndPoint);
        template.setDefaultEndpoint(endpoint);
        Exchange exchange = endpoint.createExchange();
        DefaultMessage message = new DefaultMessage();
        message.setBody((Object)artifact);
        exchange.setIn((Message)message);
        template.asyncSend(endpoint, exchange);
    }

    @Override
    public void send(IFileArtifact artifact) {
        File inputFile = artifact.getFile();
        if (inputFile == null) {
            throw new RuntimeException("file can't be null for file artifact");
        }
        DefaultProducerTemplate template = (DefaultProducerTemplate)this.context.createProducerTemplate();
        Endpoint endpoint = this.context.getEndpoint(this.startEndPoint);
        template.setDefaultEndpoint(endpoint);
        Exchange exchange = endpoint.createExchange();
        DefaultMessage message = new DefaultMessage();
        message.setHeader("metaData_fileName", (Object)inputFile.getName());
        message.setHeader("metaData_url", (Object)this.url);
        message.setBody((Object)artifact);
        exchange.setIn((Message)message);
        template.asyncSend(endpoint, exchange);
        PublishUtils.reset(artifact);
    }
}

