/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.service;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.lib.xml.XmlUtils;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.objectmodel.TerracottaPipeArtifact;
import org.yestech.publish.service.IPublishConsumer;
import org.yestech.publish.service.IPublishProcessor;
import org.yestech.publish.util.PublishUtils;

public class CamelXmlPublishConsumer
implements IPublishConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CamelXmlPublishConsumer.class);
    private IPublishProcessor processor;
    private Map<String, Object> headerParameters;
    private File tempDirectory;

    public IPublishProcessor getProcessor() {
        return this.processor;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    @Required
    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    @Required
    public void setProcessor(IPublishProcessor processor) {
        this.processor = processor;
    }

    public Map<String, Object> getHeaderParameters() {
        return this.headerParameters;
    }

    public void setHeaderParameters(Map<String, Object> headerParameters) {
        this.headerParameters = headerParameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Exchange exchange) {
        Exception throwable = exchange.getException();
        if (throwable == null) {
            Message message = exchange.getIn();
            String fileLocation = "";
            try {
                String xmlArtifact = (String)message.getBody(String.class);
                IArtifact tempArtifact = (IArtifact)XmlUtils.fromXml((String)xmlArtifact);
                message.setBody((Object)tempArtifact);
                String url = "";
                String fileName = "";
                if (PublishUtils.isTerracottaArtifact(tempArtifact)) {
                    TerracottaPipeArtifact terracottaArtifact = (TerracottaPipeArtifact)tempArtifact;
                    url = (String)terracottaArtifact.getParameter("metaData_url");
                    fileName = (String)terracottaArtifact.getParameter("metaData_fileName");
                }
                IArtifact artifact = PublishUtils.translateArtifact(tempArtifact);
                message.setBody((Object)artifact);
                if (PublishUtils.isFileArtifact(artifact)) {
                    IFileArtifact fileArtifact = (IFileArtifact)artifact;
                    fileLocation = url + fileName;
                    URL artifactUrl = new URL(fileLocation);
                    String fqn = PublishUtils.saveTempFile(this.tempDirectory, artifactUrl.openStream(), fileArtifact);
                    this.recieve(fileArtifact);
                    PublishUtils.removeTempFile(fqn);
                } else {
                    this.recieve(artifact);
                }
                if (this.headerParameters == null) return;
                for (Map.Entry<String, Object> entry : this.headerParameters.entrySet()) {
                    message.setHeader(entry.getKey(), entry.getValue());
                }
                return;
            }
            catch (Exception e) {
                logger.error("error retrieving artifact...", (Throwable)e);
                exchange.setException((Throwable)e);
                return;
            }
        } else {
            logger.error("error in the exchange", (Throwable)throwable);
        }
    }

    @Override
    public void recieve(IArtifact artifact) {
        this.processor.process(artifact);
    }
}

