/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.service;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.yestech.publish.objectmodel.ArtifactType;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.ProducerArtifactType;
import org.yestech.publish.publisher.IPublisher;
import org.yestech.publish.service.IPublishProcessor;

public class DefaultPublishProcessor
implements IPublishProcessor {
    private Map<ArtifactType, IPublisher> publishers = Maps.newHashMap();

    public void setProcessorList(List<IPublisher> publisherList) {
        for (IPublisher publisher : publisherList) {
            ProducerArtifactType producerArtifactType;
            Class<?> publisherClass = publisher.getClass();
            if (publisherClass == null || (producerArtifactType = publisherClass.getAnnotation(ProducerArtifactType.class)) == null) continue;
            for (ArtifactType artifactType : producerArtifactType.type()) {
                this.publishers.put(artifactType, publisher);
            }
        }
    }

    public Map<ArtifactType, IPublisher> getPublishers() {
        return this.publishers;
    }

    public void setPublishers(Map<ArtifactType, IPublisher> publishers) {
        this.publishers = publishers;
    }

    @Override
    public void process(IArtifact artifact) {
        IPublisher publisher = this.publishers.get((Object)artifact.getArtifactMetaData().getArtifactType());
        publisher.publish(artifact);
    }
}

