/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.service;

import java.io.File;
import java.net.URL;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.service.IPublishConsumer;
import org.yestech.publish.service.IPublishProcessor;
import org.yestech.publish.util.PublishUtils;

public class JmsQueuePublishConsumer
implements IPublishConsumer,
MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(JmsQueuePublishConsumer.class);
    private IPublishProcessor processor;
    private File tempDirectory;

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    @Required
    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public IPublishProcessor getProcessor() {
        return this.processor;
    }

    @Required
    public void setProcessor(IPublishProcessor processor) {
        this.processor = processor;
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            ObjectMessage objMessage = (ObjectMessage)message;
            String fileLocation = "";
            try {
                IArtifact artifact = PublishUtils.translateArtifact((IArtifact)objMessage.getObject());
                if (PublishUtils.isFileArtifact(artifact)) {
                    IFileArtifact fileArtifact = (IFileArtifact)artifact;
                    String url = objMessage.getStringProperty("metaData_url");
                    String fileName = objMessage.getStringProperty("metaData_fileName");
                    fileLocation = url + fileName;
                    URL artifactUrl = new URL(fileLocation);
                    String fqn = PublishUtils.saveTempFile(this.tempDirectory, artifactUrl.openStream(), fileArtifact);
                    this.recieve(fileArtifact);
                    PublishUtils.removeTempFile(fqn);
                } else {
                    this.recieve(artifact);
                }
            }
            catch (Exception e) {
                logger.error("error retrieving artifact...", (Throwable)e);
            }
        }
    }

    @Override
    public void recieve(IArtifact artifact) {
        this.processor.process(artifact);
    }
}

