/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.service;

import java.io.File;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.service.IPublishProducer;
import org.yestech.publish.util.PublishUtils;

public class JmsQueuePublishProducer
implements IPublishProducer {
    private static final Logger logger = LoggerFactory.getLogger(JmsQueuePublishProducer.class);
    private JmsTemplate jmsTemplate;
    private Queue queue;
    private String url;

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    @Required
    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public Queue getQueue() {
        return this.queue;
    }

    @Required
    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void send(final IArtifact artifact) {
        this.jmsTemplate.send((Destination)this.queue, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                ObjectMessage message = session.createObjectMessage();
                message.setObject((Serializable)artifact);
                return message;
            }
        });
    }

    @Override
    public void send(final IFileArtifact artifact) {
        final File inputFile = artifact.getFile();
        if (inputFile == null) {
            throw new RuntimeException("file can't be null for file artifact");
        }
        PublishUtils.reset(artifact);
        this.jmsTemplate.send((Destination)this.queue, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                ObjectMessage message = session.createObjectMessage();
                message.setObject((Serializable)artifact);
                message.setStringProperty("metaData_fileName", inputFile.getName());
                message.setStringProperty("metaData_url", JmsQueuePublishProducer.this.url);
                return message;
            }
        });
    }
}

