/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.service;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.terracotta.message.pipe.Pipe;
import org.terracotta.modules.annotations.Root;
import org.yestech.lib.xml.XmlUtils;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.objectmodel.TerracottaPipeArtifact;
import org.yestech.publish.service.IPublishProducer;
import org.yestech.publish.util.PublishUtils;

public class TerracottaPublishProducer
implements IPublishProducer {
    private static final Logger logger = LoggerFactory.getLogger(TerracottaPublishProducer.class);
    @Root
    private Pipe pipe;
    private String url;

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    @Required
    public void setPipe(Pipe pipe) {
        this.pipe = pipe;
    }

    @Override
    public void send(IArtifact artifact) {
        try {
            this.pipe.put((Object)XmlUtils.toXml((Object)artifact));
        }
        catch (InterruptedException e) {
            logger.error("Error putting artifact onto pipe: " + artifact, (Throwable)e);
        }
    }

    @Override
    public void send(IFileArtifact artifact) {
        try {
            File inputFile = artifact.getFile();
            if (inputFile == null) {
                throw new RuntimeException("file can't be null for file artifact");
            }
            TerracottaPipeArtifact terractottaArtifact = TerracottaPipeArtifact.create(artifact);
            terractottaArtifact.getParameters().put("metaData_fileName", inputFile.getName());
            terractottaArtifact.getParameters().put("metaData_url", this.url);
            PublishUtils.reset(artifact);
            this.pipe.put((Object)XmlUtils.toXml((Object)terractottaArtifact));
        }
        catch (InterruptedException e) {
            logger.error("Error putting artifact onto pipe: " + artifact, (Throwable)e);
        }
    }
}

