/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.util;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.lib.xml.XmlUtils;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.TerracottaPipeArtifact;
import org.yestech.publish.util.PublishUtils;

public class CamelXmlToArtifactFilter {
    private static final Logger logger = LoggerFactory.getLogger(CamelXmlToArtifactFilter.class);

    public void filter(Exchange exchange) {
        Exception throwable = exchange.getException();
        if (throwable == null) {
            Message message = exchange.getIn();
            try {
                String xmlArtifact = (String)message.getBody(String.class);
                IArtifact tempArtifact = (IArtifact)XmlUtils.fromXml((String)xmlArtifact);
                message.setBody((Object)tempArtifact);
                String url = "";
                String fileName = "";
                if (PublishUtils.isTerracottaArtifact(tempArtifact)) {
                    TerracottaPipeArtifact terracottaArtifact = (TerracottaPipeArtifact)tempArtifact;
                    url = (String)terracottaArtifact.getParameter("metaData_url");
                    fileName = (String)terracottaArtifact.getParameter("metaData_fileName");
                }
                IArtifact artifact = PublishUtils.translateArtifact(tempArtifact);
                message.setBody((Object)artifact);
                message.setHeader("__raw_xml_artifact__", (Object)xmlArtifact);
            }
            catch (Exception e) {
                logger.error("error retrieving artifact...", (Throwable)e);
                exchange.setException((Throwable)e);
            }
        } else {
            logger.error("error in the exchange", (Throwable)throwable);
        }
    }
}

