/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.publish.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.lib.crypto.MessageDigestUtils;
import org.yestech.publish.objectmodel.IArtifact;
import org.yestech.publish.objectmodel.IArtifactOwner;
import org.yestech.publish.objectmodel.IFileArtifact;
import org.yestech.publish.objectmodel.IFileArtifactMetaData;
import org.yestech.publish.objectmodel.TerracottaPipeArtifact;

public class PublishUtils {
    private static final Logger logger = LoggerFactory.getLogger(PublishUtils.class);

    public static String generateUniqueIdentifier(IArtifactOwner owner) {
        return MessageDigestUtils.sha1Hash((String)owner.getOwnerIdentifier().toString());
    }

    public static IArtifact translateArtifact(IArtifact artifact) {
        IArtifact artifactType = artifact;
        if (artifact instanceof TerracottaPipeArtifact) {
            artifactType = ((TerracottaPipeArtifact)artifact).getArtifact();
        }
        return artifactType;
    }

    public static String generateUniqueIdentifier(IFileArtifactMetaData metaData) {
        return MessageDigestUtils.sha1Hash((String)UUID.randomUUID().toString()) + "_" + metaData.getFileName();
    }

    public static boolean isFileArtifact(IArtifact artifact) {
        return artifact instanceof IFileArtifact;
    }

    public static boolean isTerracottaArtifact(IArtifact artifact) {
        return artifact instanceof TerracottaPipeArtifact;
    }

    public static void reset(IFileArtifact artifact) {
        if (artifact != null) {
            artifact.setFile(null);
            artifact.setStream(null);
        }
    }

    public static void removeTempFile(String fqn) {
        File tmpFile;
        if (logger.isInfoEnabled()) {
            logger.info("removing file: " + fqn);
        }
        if ((tmpFile = new File(fqn)).exists()) {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveTempFile(File tempDirectory, InputStream inputStream, IFileArtifact artifact) {
        String fqn;
        block6: {
            fqn = "";
            FileOutputStream fileOutputStream = null;
            try {
                String ownerId = PublishUtils.generateUniqueIdentifier(artifact.getArtifactMetaData().getArtifactOwner());
                String directory = tempDirectory + File.separator + ownerId + File.separator;
                File dir = new File(directory);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                fqn = directory + artifact.getArtifactMetaData().getFileName();
                File newFile = new File(fqn);
                fileOutputStream = FileUtils.openOutputStream((File)newFile);
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                artifact.getArtifactMetaData().setSize(newFile.length());
                artifact.setStream(new FileInputStream(newFile));
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (IOException e) {
                logger.error("error saving streaming data: " + e);
                break block6;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(fileOutputStream);
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
        return fqn;
    }
}

