/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.rpx;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.rpx.RPXClient;
import org.yestech.rpx.auth.FacebookAuthProvider;
import org.yestech.rpx.auth.GoogleAuthProvider;
import org.yestech.rpx.auth.MicrosoftLiveProvider;
import org.yestech.rpx.auth.RPXAuthProvider;
import org.yestech.rpx.auth.TwitterAuthProvider;
import org.yestech.rpx.objectmodel.AuthInfoResponse;
import org.yestech.rpx.objectmodel.GetContactsResponse;
import org.yestech.rpx.objectmodel.MappingsResponse;
import org.yestech.rpx.objectmodel.RPXException;
import org.yestech.rpx.objectmodel.RPXStat;
import org.yestech.rpx.objectmodel.RPXUtil;

public class DefaultRPXClient
implements RPXClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRPXClient.class);
    private static final String RPX_API_URL = "https://rpxnow.com/api/v2/";
    private String apiKey;
    private String realm;

    public DefaultRPXClient(String apiKey, String realm) {
        this.apiKey = apiKey;
        this.realm = realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthInfoResponse authInfo(String token, boolean extended) throws IOException, JSONException, RPXException {
        StringBuilder url = new StringBuilder(RPX_API_URL);
        url.append("auth_info");
        url.append("?token=").append(token);
        url.append("&apiKey=").append(this.apiKey);
        url.append("&extended=").append(extended);
        HttpClient client = this.getHttpClient();
        GetMethod get = new GetMethod(url.toString());
        try {
            client.executeMethod((HttpMethod)get);
            String body = get.getResponseBodyAsString();
            JSONObject jo = new JSONObject(body);
            RPXException ex = RPXException.fromJSON(jo);
            if (ex != null) {
                throw ex;
            }
            AuthInfoResponse authInfoResponse = AuthInfoResponse.fromJson(jo);
            return authInfoResponse;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RPXStat map(String identifier, String primaryKey, boolean overwrite) throws IOException, JSONException, RPXException {
        StringBuilder url = new StringBuilder(RPX_API_URL);
        url.append("map");
        url.append("?identifier=").append(identifier);
        url.append("&primaryKey=").append(primaryKey);
        url.append("&overwrite=").append(overwrite);
        HttpClient client = this.getHttpClient();
        GetMethod get = new GetMethod(url.toString());
        try {
            client.executeMethod((HttpMethod)get);
            String body = get.getResponseBodyAsString();
            JSONObject jo = new JSONObject(body);
            RPXException ex = RPXException.fromJSON(jo);
            if (ex != null) {
                throw ex;
            }
            RPXStat rPXStat = RPXStat.fromString(RPXUtil.jsonString(jo, "stat"));
            return rPXStat;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingsResponse getMappings(String primaryKey) throws IOException, JSONException, RPXException {
        StringBuilder url = new StringBuilder(RPX_API_URL).append("mappings").append("?apiKey=").append(this.apiKey).append("&primaryKey=").append(primaryKey);
        HttpClient client = this.getHttpClient();
        GetMethod get = new GetMethod(url.toString());
        try {
            client.executeMethod((HttpMethod)get);
            String body = get.getResponseBodyAsString();
            JSONObject jo = new JSONObject(body);
            RPXException ex = RPXException.fromJSON(jo);
            if (ex != null) {
                throw ex;
            }
            MappingsResponse mappingsResponse = MappingsResponse.fromJson(jo);
            return mappingsResponse;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContactsResponse getContacts(String identifier) throws JSONException, IOException, RPXException {
        StringBuilder url = new StringBuilder(RPX_API_URL);
        url.append("get_contacts");
        url.append("?apiKey=").append(this.apiKey);
        url.append("&identifier=").append(identifier);
        GetMethod get = new GetMethod(url.toString());
        try {
            HttpClient client = this.getHttpClient();
            client.executeMethod((HttpMethod)get);
            String body = get.getResponseBodyAsString();
            JSONObject jo = new JSONObject(body);
            RPXException ex = RPXException.fromJSON(jo);
            if (ex != null) {
                throw ex;
            }
            GetContactsResponse getContactsResponse = GetContactsResponse.fromJson(jo);
            return getContactsResponse;
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public String buildAuthRedirect(RPXClient.Provider provider, String tokenUrl) throws IOException {
        if (provider == RPXClient.Provider.MICROSOFT_LIVE) {
            return this.buildAuthRedirect(new MicrosoftLiveProvider(), tokenUrl);
        }
        if (provider == RPXClient.Provider.GOOGLE) {
            return this.buildAuthRedirect(new GoogleAuthProvider(), tokenUrl);
        }
        if (provider == RPXClient.Provider.FACEBOOK) {
            return this.buildAuthRedirect(new FacebookAuthProvider(), tokenUrl);
        }
        if (provider == RPXClient.Provider.TWITTER) {
            return this.buildAuthRedirect(new TwitterAuthProvider(), tokenUrl);
        }
        throw new IllegalArgumentException("unknown provider" + (Object)((Object)provider));
    }

    @Override
    public void setStatus(String identifier, String status) throws IOException, JSONException, RPXException {
        GetMethod get = null;
        try {
            StringBuilder url = new StringBuilder(RPX_API_URL).append("set_status").append("?apiKey=").append(this.apiKey).append("&identifier").append(identifier).append("status").append(URLEncoder.encode(status, "UTF-8"));
            get = new GetMethod(url.toString());
            HttpClient client = this.getHttpClient();
            client.executeMethod((HttpMethod)get);
            String body = get.getResponseBodyAsString();
            JSONObject jo = new JSONObject(body);
            RPXException ex = RPXException.fromJSON(jo);
            if (ex != null) {
                throw ex;
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    @Override
    public String buildAuthRedirect(RPXAuthProvider provider, String tokenUrl) {
        return provider.getRedirectUrl(this.realm, RPXUtil.uriEncode(tokenUrl));
    }

    protected HttpClient getHttpClient() {
        return new HttpClient();
    }
}

