/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.rpx.objectmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.json.JSONArray;
import org.json.JSONObject;
import org.yestech.rpx.objectmodel.RPXUtil;
import org.yestech.rpx.objectmodel.TypeValue;

public class Contact
implements Serializable {
    private String displayName;
    private Collection<TypeValue> emails = Collections.emptyList();

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Collection<TypeValue> getEmails() {
        return this.emails;
    }

    public void setEmails(Collection<TypeValue> emails) {
        this.emails = emails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        if (this.displayName != null ? !this.displayName.equals(contact.displayName) : contact.displayName != null) {
            return false;
        }
        return !(this.emails != null ? !((Object)this.emails).equals(contact.emails) : contact.emails != null);
    }

    public int hashCode() {
        int result = this.displayName != null ? this.displayName.hashCode() : 0;
        result = 31 * result + (this.emails != null ? ((Object)this.emails).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Contact{displayName='" + this.displayName + '\'' + ", emails=" + this.emails + '}';
    }

    public static Contact fromJson(JSONObject json) {
        Contact c = new Contact();
        c.displayName = RPXUtil.jsonString(json, "displayName");
        JSONArray jsonArray = RPXUtil.jsonArray(json, "emails");
        if (jsonArray != null && jsonArray.length() > 0) {
            c.emails = new ArrayList<TypeValue>(jsonArray.length());
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jo = RPXUtil.jsonObject(jsonArray, i);
                c.emails.add(TypeValue.fromJson(jo));
            }
        }
        return c;
    }
}

