/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.rpx.objectmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.yestech.rpx.objectmodel.Contact;
import org.yestech.rpx.objectmodel.RPXStat;
import org.yestech.rpx.objectmodel.RPXUtil;

public class GetContactsResponse
implements Serializable {
    private int startIndex;
    private int itemsPerPage;
    private int totalResults;
    private RPXStat stat;
    private Collection<Contact> entry = Collections.emptyList();

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(int totalResults) {
        this.totalResults = totalResults;
    }

    public RPXStat getStat() {
        return this.stat;
    }

    public void setStat(RPXStat stat) {
        this.stat = stat;
    }

    public Collection<Contact> getEntry() {
        return this.entry;
    }

    public void setEntry(Collection<Contact> entry) {
        this.entry = entry;
    }

    public static GetContactsResponse fromJson(JSONObject json) throws JSONException {
        GetContactsResponse r = new GetContactsResponse();
        r.stat = RPXStat.fromString(json.getString("stat"));
        json = RPXUtil.jsonObject(json, "response");
        r.startIndex = RPXUtil.jsonInt(json, "startIndex");
        r.itemsPerPage = RPXUtil.jsonInt(json, "itemsPerPage");
        r.totalResults = RPXUtil.jsonInt(json, "totalResults");
        JSONArray jsonArray = RPXUtil.jsonArray(json, "entry");
        if (jsonArray != null && jsonArray.length() > 0) {
            r.entry = new ArrayList<Contact>(jsonArray.length());
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jo = RPXUtil.jsonObject(jsonArray, i);
                r.entry.add(Contact.fromJson(jo));
            }
        }
        return r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetContactsResponse that = (GetContactsResponse)o;
        if (this.itemsPerPage != that.itemsPerPage) {
            return false;
        }
        if (this.startIndex != that.startIndex) {
            return false;
        }
        if (this.totalResults != that.totalResults) {
            return false;
        }
        if (this.entry != null ? !((Object)this.entry).equals(that.entry) : that.entry != null) {
            return false;
        }
        return this.stat == that.stat;
    }

    public int hashCode() {
        int result = this.startIndex;
        result = 31 * result + this.itemsPerPage;
        result = 31 * result + this.totalResults;
        result = 31 * result + (this.stat != null ? this.stat.hashCode() : 0);
        result = 31 * result + (this.entry != null ? ((Object)this.entry).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GetContactsResponse{startIndex=" + this.startIndex + ", itemsPerPage=" + this.itemsPerPage + ", totalResults=" + this.totalResults + ", stat=" + (Object)((Object)this.stat) + ", entry=" + this.entry + '}';
    }
}

