/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.rpx.objectmodel;

import org.json.JSONObject;
import org.yestech.rpx.objectmodel.RPXStat;
import org.yestech.rpx.objectmodel.RPXUtil;

public class RPXException
extends Exception {
    private int code;
    private RPXStat stat;

    public RPXException(String message, int code, RPXStat stat) {
        super(message);
        this.code = code;
        this.stat = stat;
    }

    public int getCode() {
        return this.code;
    }

    public RPXStat getStat() {
        return this.stat;
    }

    public static RPXException fromJSON(JSONObject json) {
        JSONObject err = RPXUtil.jsonObject(json, "err");
        if (err == null) {
            return null;
        }
        int code = RPXUtil.jsonInt(err, "code");
        String msg = RPXUtil.jsonString(err, "msg");
        RPXStat stat = RPXStat.fromString(RPXUtil.jsonString(json, "stat"));
        return new RPXException(msg, code, stat);
    }
}

