/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.rpx.objectmodel;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RPXUtil {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    public static DateTime fromRPXDateString(String string) {
        if (string == null) {
            return null;
        }
        return formatter.parseDateTime(string);
    }

    public static String toRPXDateString(DateTime dt) {
        return dt.toString(formatter);
    }

    public static String jsonString(JSONObject jo, String property) {
        try {
            if (jo != null) {
                return jo.getString(property);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public static JSONArray jsonArray(JSONObject jo, String property) {
        try {
            if (jo != null) {
                return jo.getJSONArray(property);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public static JSONObject jsonObject(JSONObject jo, String property) {
        try {
            if (jo != null) {
                return jo.getJSONObject(property);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public static int jsonInt(JSONObject jo, String property) {
        try {
            if (jo != null) {
                return jo.getInt(property);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return 0;
    }

    public static JSONObject jsonObject(JSONArray array, int index) {
        try {
            if (array != null) {
                return array.getJSONObject(index);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public static String jsonString(JSONArray array, int index) {
        try {
            if (array != null) {
                return array.getString(index);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public static String uriEncode(String uri) {
        int length = uri.length();
        if (length == 0) {
            return uri;
        }
        StringBuffer results = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            char c = uri.charAt(i);
            switch (c) {
                case ' ': 
                case '\"': 
                case '$': 
                case '%': 
                case '&': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': {
                    try {
                        byte[] octets = uri.substring(i, i + 1).getBytes();
                        for (int j = 0; j < octets.length; ++j) {
                            String hexVal = Integer.toHexString(octets[j]).toUpperCase();
                            if (hexVal.length() == 2) {
                                results.append("%").append(hexVal);
                                continue;
                            }
                            results.append("%0").append(hexVal);
                        }
                        continue block5;
                    }
                    catch (Exception e) {
                        continue block5;
                    }
                }
                default: {
                    results.append(c);
                }
            }
        }
        return results.toString();
    }
}

