/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.wizard;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.wizard.IPhasedEvent;
import org.yestech.wizard.IPhasedProcessor;
import org.yestech.wizard.IPhasedScreen;
import org.yestech.wizard.PhasedEnum;

public abstract class BasePhasedScreen
implements IPhasedScreen {
    private static final Logger logger = LoggerFactory.getLogger(BasePhasedScreen.class);
    private IPhasedEvent event;

    protected IPhasedEvent getEvent() {
        return this.event;
    }

    protected void setEvent(IPhasedEvent event) {
        this.event = event;
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public abstract Object saveData();

    @Override
    public void nextPressed(IPhasedEvent event) {
        this.setEvent(event);
        if (!this.validateData()) {
            return;
        }
        this.saveData();
        this.getPhasedProcess().phasedProcessHandler(PhasedEnum.MSG_NEXT, null);
    }

    private IPhasedProcessor getPhasedProcess() {
        return this.getEvent().getProcessor();
    }

    @Override
    public void prevPressed(IPhasedEvent event) {
        this.setEvent(event);
        this.getPhasedProcess().phasedProcessHandler(PhasedEnum.MSG_PREV, null);
    }

    @Override
    public void cancelPressed(IPhasedEvent event) {
        this.setEvent(event);
        this.getPhasedProcess().phasedProcessHandler(PhasedEnum.MSG_CANCEL, null);
    }

    public void skipToPhase(int newPhase) {
        this.setEvent(this.event);
        this.getPhasedProcess().phasedProcessHandler(PhasedEnum.MSG_SKIP, newPhase);
    }

    @Override
    public void finishPressed(IPhasedEvent event) {
        this.setEvent(event);
        if (!this.validateData()) {
            return;
        }
        this.saveData();
        this.getPhasedProcess().phasedProcessHandler(PhasedEnum.MSG_FINISH, null);
    }
}

