/*
 * Decompiled with CFR 0.152.
 */
package org.yestech.wizard;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yestech.wizard.IPhasedProcessor;
import org.yestech.wizard.PhasedEnum;

public abstract class PhasedProcessor<R, D>
implements IPhasedProcessor<R, D> {
    private static final Logger logger = LoggerFactory.getLogger(PhasedProcessor.class);
    private List<Integer> frameStack = new ArrayList<Integer>();
    private int currentPhase;

    @Override
    public R phasedProcessHandler(PhasedEnum phase, D data) {
        switch (phase) {
            case MSG_INIT: {
                this.currentPhase = null != data && data instanceof Integer ? (Integer)data : 0;
                this.frameStack.add(this.currentPhase);
                break;
            }
            case MSG_NEXT: {
                ++this.currentPhase;
                this.frameStack.add(this.currentPhase);
                break;
            }
            case MSG_PREV: {
                if (this.frameStack.size() <= 1) {
                    logger.error("Error: Popped too much off the stack!");
                    throw new RuntimeException("Error: Popped too much off the stack!");
                }
                int prevPhase = this.frameStack.get(this.frameStack.size() - 2);
                this.frameStack.remove(this.frameStack.size() - 1);
                this.currentPhase = prevPhase;
                break;
            }
            case MSG_SKIP: {
                if (null != data && data instanceof Integer) {
                    this.currentPhase = (Integer)data;
                    break;
                }
                logger.error("Error: phasedProcessHandler got MSG_SKIP with bad phase parameter.");
                throw new RuntimeException("Error: phasedProcessHandler got MSG_SKIP with bad phase parameter.");
            }
            case MSG_FINISH: {
                return this.processFinished(data);
            }
            case MSG_CANCEL: {
                return this.processCancelled(data);
            }
            default: {
                logger.error("Error: phasedProcessHandler: Unknown msg: " + (Object)((Object)phase));
                throw new RuntimeException("Error: phasedProcessHandler: Unknown msg: " + (Object)((Object)phase));
            }
        }
        return this.performCurrentPhase(data);
    }

    public abstract R performCurrentPhase(D var1);

    public R beginProcess() {
        return this.beginProcess(null);
    }

    public R beginProcess(D data) {
        return this.phasedProcessHandler(PhasedEnum.MSG_INIT, data);
    }

    public R cancelProcess() {
        return this.cancelProcess(null);
    }

    public R cancelProcess(D data) {
        return this.phasedProcessHandler(PhasedEnum.MSG_CANCEL, data);
    }

    public R finishProcess() {
        return this.finishProcess(null);
    }

    public R finishProcess(D data) {
        return this.phasedProcessHandler(PhasedEnum.MSG_FINISH, data);
    }

    protected int getCurrentPhase() {
        return this.currentPhase;
    }

    protected void setCurrentPhase(int phase) {
        this.currentPhase = phase;
    }

    protected void setCurrentMessage(int msg) {
        this.currentPhase = msg;
    }

    protected int getCurrentMessage() {
        return this.currentPhase;
    }

    protected R processCancelled(D data) {
        this.currentPhase = -1;
        return null;
    }

    protected R processFinished(D data) {
        this.currentPhase = -1;
        return null;
    }
}

