/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.lib.acd;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.yetiz.lib.acd.ACDSession;
import org.yetiz.lib.acd.Entity.AccountInfo;
import org.yetiz.lib.acd.Entity.AccountQuota;
import org.yetiz.lib.acd.Entity.AccountUsage;
import org.yetiz.lib.acd.Entity.FileInfo;
import org.yetiz.lib.acd.Entity.FolderInfo;
import org.yetiz.lib.acd.Entity.NodeInfo;
import org.yetiz.lib.acd.Entity.NodeInfoList;
import org.yetiz.lib.acd.Entity.Properties;
import org.yetiz.lib.acd.Entity.Property;
import org.yetiz.lib.acd.api.v1.Account;
import org.yetiz.lib.acd.api.v1.Nodes;
import org.yetiz.lib.acd.api.v1.Trash;

public class ACD {
    private ACDSession acdSession = null;

    public ACD(ACDSession acdSession) {
        this.acdSession = acdSession;
    }

    public AccountInfo getUserInfo() {
        return Account.getAccountInfo(this.acdSession);
    }

    public AccountUsage getUserUsage() {
        return Account.getAccountUsage(this.acdSession);
    }

    public AccountQuota getUserQuota() {
        return Account.getAccountQuota(this.acdSession);
    }

    public FileInfo uploadFile(String parentID, String name, File file) {
        FileInfo fileInfo = new FileInfo();
        if (parentID != null && !parentID.equals("")) {
            fileInfo.setParents(new String[]{parentID});
        }
        fileInfo.setName(name);
        return Nodes.uploadFile(this.acdSession, fileInfo, file);
    }

    public FileInfo updateFile(String id, File file) {
        return Nodes.overwriteFile(this.acdSession, new FileInfo(id), file);
    }

    public FileInfo renameFile(String id, String name) {
        FileInfo fileInfo = new FileInfo(id);
        fileInfo.setName(name);
        return Nodes.updateFileMetadata(this.acdSession, fileInfo);
    }

    public InputStream getFile(String id) {
        return Nodes.downloadFile(this.acdSession, new FileInfo(id));
    }

    public FileInfo removeFile(String id) {
        return (FileInfo)Trash.moveNodeToTrash(this.acdSession, new FileInfo(id));
    }

    public FileInfo restoreFile(String id) {
        return (FileInfo)Trash.restore(this.acdSession, new FileInfo(id));
    }

    public FolderInfo createFolder(String parentID, String name) {
        FolderInfo folderInfo = new FolderInfo();
        folderInfo.setName(name);
        if (parentID != null && !parentID.equals("")) {
            folderInfo.setParents(new String[]{parentID});
        }
        return Nodes.createFolder(this.acdSession, folderInfo);
    }

    public FolderInfo renameFolder(String id, String name) {
        FolderInfo folderInfo = new FolderInfo(id);
        folderInfo.setName(name);
        return Nodes.updateFolderMetadata(this.acdSession, folderInfo);
    }

    public FolderInfo removeFolder(String id) {
        return (FolderInfo)Trash.moveNodeToTrash(this.acdSession, new FolderInfo(id));
    }

    public FolderInfo restoreFolder(String id) {
        return (FolderInfo)Trash.restore(this.acdSession, new FolderInfo(id));
    }

    private List<NodeInfo> getList(String id, String startToken) {
        ArrayList<NodeInfo> rtnList = new ArrayList<NodeInfo>();
        NodeInfoList nodeInfoList = Nodes.getChildList(this.acdSession, new FolderInfo(id), startToken);
        rtnList.addAll(nodeInfoList.getList());
        if (nodeInfoList.hasNext().booleanValue()) {
            rtnList.addAll(this.getList(id, nodeInfoList.getNextToken()));
        }
        return rtnList;
    }

    public List<NodeInfo> getList(String id) {
        return this.getList(id, null);
    }

    public void addProperty(String id, String key, String value) {
        Nodes.addProperty(this.acdSession, new FileInfo(id), new Property(key, value));
    }

    public void removeProperty(String id, String key) {
        Nodes.deleteProperty(this.acdSession, new FileInfo(id), key);
    }

    public Properties getProperties(String id) {
        return Nodes.getProperties(this.acdSession, new FileInfo(id), this.acdSession.getConfigure().getOwner());
    }

    public void destroy() {
        this.acdSession.destroy();
    }
}

