/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.lib.acd.api.v1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.yetiz.lib.acd.ACDSession;
import org.yetiz.lib.acd.Entity.AssetInfo;
import org.yetiz.lib.acd.Entity.FileInfo;
import org.yetiz.lib.acd.Entity.FileInfoList;
import org.yetiz.lib.acd.Entity.FolderInfo;
import org.yetiz.lib.acd.Entity.FolderInfoList;
import org.yetiz.lib.acd.Entity.NodeInfo;
import org.yetiz.lib.acd.Entity.NodeInfoList;
import org.yetiz.lib.acd.Entity.Properties;
import org.yetiz.lib.acd.Entity.Property;
import org.yetiz.lib.acd.Utils;
import org.yetiz.lib.acd.exception.BadContentException;
import org.yetiz.lib.utils.Log;

public class Nodes {
    public static String root = "nodes";

    public static FileInfo uploadFile(ACDSession acdSession, FileInfo uploadedFileInfo, File uploadFile) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = root + "?suppress=deduplication";
        CreateStructure createStructure = new CreateStructure();
        createStructure.name = uploadedFileInfo.getName();
        createStructure.kind = uploadedFileInfo.getKind();
        createStructure.parents = uploadedFileInfo.getParents();
        createStructure.labels = uploadedFileInfo.getLabels();
        createStructure.description = null;
        Request request = new RequestBuilder().setUrl(acdSession.getContentUrl(resourceEndpoint)).setMethod("POST").addBodyPart((Part)new StringPart("metadata", Utils.getGson().toJson((Object)createStructure))).addBodyPart((Part)new FilePart("content", uploadFile)).build();
        Response response = acdSession.execute(request);
        FileInfo rtnProperties = (FileInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FileInfo.class);
        return rtnProperties;
    }

    public static FileInfo overwriteFile(ACDSession acdSession, FileInfo overwritedFileInfo, File uploadFile) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", overwritedFileInfo.getId(), "/content");
        CreateStructure createStructure = new CreateStructure();
        Request request = new RequestBuilder().setUrl(acdSession.getContentUrl(resourceEndpoint)).setMethod("PUT").addBodyPart((Part)new FilePart("content", uploadFile)).build();
        Response response = acdSession.execute(request);
        FileInfo rtnProperties = (FileInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FileInfo.class);
        return rtnProperties;
    }

    public static InputStream downloadFile(ACDSession acdSession, FileInfo downloadedFileInfo) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", downloadedFileInfo.getId(), "/content");
        CreateStructure createStructure = new CreateStructure();
        Request request = new RequestBuilder().setUrl(acdSession.getContentUrl(resourceEndpoint)).setMethod("GET").build();
        Response response = acdSession.execute(request);
        try {
            return response.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new BadContentException("getResponseBodyAsStream()");
        }
    }

    public static FileInfoList getFileInfoLists(ACDSession acdSession, String startToken) {
        return Nodes.getFileInfoLists(acdSession, startToken, null, null, true, null);
    }

    public static FileInfoList getFileInfoLists(ACDSession acdSession, String startToken, String sort, Integer limit, Boolean withTempLink, String withAsset) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = root.concat("?filters=kind:FILE");
        if (startToken != null) {
            resourceEndpoint = Utils.stringFormatter("{}&startToken={}", resourceEndpoint, startToken);
        }
        if (startToken != sort) {
            resourceEndpoint = Utils.stringFormatter("{}&sort={}", resourceEndpoint, sort);
        }
        if (limit != null && limit > 0) {
            resourceEndpoint = Utils.stringFormatter("{}&limit={}", resourceEndpoint, limit);
        }
        if (withTempLink.booleanValue()) {
            resourceEndpoint = Utils.stringFormatter("{}&tempLink=true", resourceEndpoint);
        }
        if (withAsset != null) {
            resourceEndpoint = Utils.stringFormatter("{}&asset={}", resourceEndpoint, withAsset);
        }
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        FileInfoList fileInfoList = (FileInfoList)Utils.getGson().fromJson(Utils.getResponseBody(response), FileInfoList.class);
        return fileInfoList;
    }

    public static FileInfo getFileMetadata(ACDSession acdSession, String id) {
        return Nodes.getFileMetadata(acdSession, id, true, "ALL");
    }

    public static FileInfo getFileMetadata(ACDSession acdSession, String id, Boolean withTempLink, String withAsset) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", id, "?");
        if (withTempLink.booleanValue()) {
            resourceEndpoint = Utils.stringAppender(resourceEndpoint, "tempLink=true");
        }
        if (withAsset != null && withAsset != "") {
            resourceEndpoint = Utils.stringAppender(resourceEndpoint, "&asset=", withAsset);
        }
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        FileInfo fileInfo = (FileInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FileInfo.class);
        return fileInfo;
    }

    public static FileInfo updateFileMetadata(ACDSession acdSession, FileInfo fileInfo) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", fileInfo.getId());
        PatchStructure patchStructure = new PatchStructure();
        patchStructure.name = fileInfo.getName();
        patchStructure.description = fileInfo.getDescription();
        patchStructure.labels = fileInfo.getLabels();
        String body = Utils.getGson().toJson((Object)patchStructure);
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("PATCH").setBody(body).build());
        FileInfo rtnFileInfo = (FileInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FileInfo.class);
        return rtnFileInfo;
    }

    public static FolderInfo getRootFolder(ACDSession acdSession) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "?filters=isRoot:true");
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        FolderInfoList folderInfoList = (FolderInfoList)Utils.getGson().fromJson(Utils.getResponseBody(response), FolderInfoList.class);
        return folderInfoList.getCount() == 1L ? (FolderInfo)folderInfoList.getList().get(0) : null;
    }

    public static FolderInfo createFolder(ACDSession acdSession, FolderInfo folderInfo) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = root;
        CreateStructure createStructure = new CreateStructure();
        createStructure.name = folderInfo.getName();
        createStructure.description = folderInfo.getDescription();
        createStructure.labels = folderInfo.getLabels();
        createStructure.kind = "FOLDER";
        createStructure.parents = folderInfo.getParents();
        String body = Utils.getGson().toJson((Object)createStructure);
        Request request = new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("POST").setBody(body).build();
        Response response = acdSession.execute(request);
        FolderInfo rtnFolderInfo = (FolderInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FolderInfo.class);
        return rtnFolderInfo;
    }

    public static FolderInfo getFolderMetadata(ACDSession acdSession, String id) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", id);
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        FolderInfo folderInfo = (FolderInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FolderInfo.class);
        return folderInfo;
    }

    public static FolderInfo updateFolderMetadata(ACDSession acdSession, FolderInfo folderInfo) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", folderInfo.getId());
        PatchStructure patchStructure = new PatchStructure();
        patchStructure.name = folderInfo.getName();
        patchStructure.description = folderInfo.getDescription();
        patchStructure.labels = folderInfo.getLabels();
        String body = Utils.getGson().toJson((Object)patchStructure);
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("PATCH").setBody(body).build());
        FolderInfo rtnFolderInfo = (FolderInfo)Utils.getGson().fromJson(Utils.getResponseBody(response), FolderInfo.class);
        return rtnFolderInfo;
    }

    public static FolderInfoList getFolderInfoLists(ACDSession acdSession, String startToken) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = root.concat("?filters=kind:FOLDER");
        if (startToken != null) {
            resourceEndpoint = Utils.stringFormatter("{}&startToken={}", resourceEndpoint, startToken);
        }
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        FolderInfoList folderInfoList = (FolderInfoList)Utils.getGson().fromJson(Utils.getResponseBody(response), FolderInfoList.class);
        return folderInfoList;
    }

    public static void addChildToNode(ACDSession acdSession, NodeInfo parent, NodeInfo child) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", parent.getId(), "/children/", child.getId());
        Request request = new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("PUT").build();
        acdSession.execute(request);
    }

    public static void removeChildFromNode(ACDSession acdSession, NodeInfo parent, NodeInfo child) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", parent.getId(), "/children/", child.getId());
        Request request = new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("DELETE").build();
        Log.i("removeChildFromNode", request.toString());
        acdSession.execute(request);
    }

    public static NodeInfoList getChildList(ACDSession acdSession, NodeInfo parent, String startToken) {
        return Nodes.getChildList(acdSession, parent, "kind:(FOLDER* OR FILE*)", startToken);
    }

    public static NodeInfoList getChildList(ACDSession acdSession, NodeInfo parent, String filters, String startToken) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", parent.getId(), "/children?");
        if (filters != null && !filters.equals("")) {
            resourceEndpoint = Utils.stringFormatter("{}&filters={}", resourceEndpoint, filters);
        }
        if (startToken != null) {
            resourceEndpoint = Utils.stringFormatter("{}&startToken={}", resourceEndpoint, startToken);
        }
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        JsonObject responseObject = (JsonObject)new JsonParser().parse(Utils.getResponseBody(response));
        ArrayList<NodeInfo> data = new ArrayList<NodeInfo>();
        for (JsonObject object : responseObject.get("data").getAsJsonArray()) {
            if (object.get("kind").getAsString().equals("FILE")) {
                data.add((NodeInfo)Utils.getGson().fromJson((JsonElement)object, FileInfo.class));
            }
            if (object.get("kind").getAsString().equals("FOLDER")) {
                data.add((NodeInfo)Utils.getGson().fromJson((JsonElement)object, FolderInfo.class));
            }
            if (!object.get("kind").getAsString().equals("ASSET")) continue;
            data.add((NodeInfo)Utils.getGson().fromJson((JsonElement)object, AssetInfo.class));
        }
        NodeInfoList nodeInfoList = new NodeInfoList((Long)responseObject.get("count").getAsLong(), responseObject.has("nextToken") ? responseObject.get("nextToken").getAsString() : "", (List<NodeInfo>)data);
        return nodeInfoList;
    }

    public static Property addProperty(ACDSession acdSession, NodeInfo node, Property property) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", node.getId(), "/properties/", acdSession.getConfigure().getOwner(), "/", property.getKey());
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setBody(Utils.stringFormatter("{\"value\":\"{}\"}", property.getValue())).setMethod("PUT").build());
        Property rtnProperty = (Property)Utils.getGson().fromJson(Utils.getResponseBody(response), Property.class);
        return rtnProperty;
    }

    public static Properties getProperties(ACDSession acdSession, NodeInfo node, String owner) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", node.getId(), "/properties/", owner);
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        Properties rtnProperties = (Properties)Utils.getGson().fromJson(Utils.getResponseBody(response), Properties.class);
        rtnProperties.setOwner(owner);
        return rtnProperties;
    }

    public static Property getProperty(ACDSession acdSession, NodeInfo node, String owner, String key) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", node.getId(), "/properties/", owner, "/", key);
        Response response = acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("GET").build());
        Property rtnProperty = (Property)Utils.getGson().fromJson(Utils.getResponseBody(response), Property.class);
        rtnProperty.setOwner(owner);
        return rtnProperty;
    }

    public static void deleteProperty(ACDSession acdSession, NodeInfo node, String key) {
        Log.d(Utils.getCurrentMethodName());
        String resourceEndpoint = Utils.stringAppender(root, "/", node.getId(), "/properties/", acdSession.getConfigure().getOwner(), "/", key);
        acdSession.execute(new RequestBuilder().setUrl(acdSession.getMetadataUrl(resourceEndpoint)).setMethod("DELETE").build());
    }

    public static class CreateStructure
    extends PatchStructure {
        protected String kind;
        protected String[] parents = new String[0];
    }

    public static class PatchStructure {
        protected String name;
        protected String description;
        protected String[] labels = new String[0];
    }
}

