/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.lib.acd.exception;

import com.ning.http.client.Response;
import java.io.IOException;
import org.yetiz.lib.acd.ResponseCode;
import org.yetiz.lib.acd.exception.BadContentException;
import org.yetiz.lib.utils.Log;

public class ACDResponseException
extends RuntimeException {
    protected ResponseCode.Error statusCode;
    private String responseBody = "";

    public ACDResponseException(Response response) {
        try {
            this.responseBody = response.hasResponseBody() ? response.getResponseBody() : response.getStatusText();
        }
        catch (IOException e) {
            throw new BadContentException(e.getMessage());
        }
        try {
            Log.e(Class.forName(Thread.currentThread().getStackTrace()[2].getClassName()), this.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public String getMessage() {
        return this.responseBody;
    }

    public int getStatusCode() {
        return this.statusCode.getValue();
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getAmazonDescription() {
        return "ACDResponseException Description";
    }
}

