/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.yetiz.utils.hbase.HTableModel;
import org.yetiz.utils.hbase.TableName;
import org.yetiz.utils.hbase.exception.UnHandledException;
import org.yetiz.utils.hbase.exception.YHBaseException;

public class HBaseTable {
    private final Table table;
    private final TableName tableName;
    private final Async async;
    private final Fast fast;
    private final Model model;

    protected HBaseTable(TableName tableName, Table table, ConcurrentHashMap<TableName, LinkedBlockingQueue<Async.AsyncPackage>> asyncPackages, ConcurrentHashMap<TableName, LinkedBlockingQueue<Row>> fastCollection) {
        this.tableName = tableName;
        this.table = table;
        this.async = new Async(tableName, asyncPackages);
        this.fast = new Fast(tableName, fastCollection);
        this.model = new Model();
    }

    public Model model() {
        return this.model;
    }

    public void release() {
        try {
            this.table().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Table table() {
        return this.table;
    }

    public boolean exists(Get get) {
        try {
            return this.table().exists(get);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    private YHBaseException convertedException(Throwable throwable) {
        if (throwable instanceof YHBaseException) {
            return (YHBaseException)throwable;
        }
        return new UnHandledException(throwable);
    }

    public boolean[] exists(List<Get> gets) {
        try {
            return this.table().existsAll(gets);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result append(Append append) {
        try {
            return this.table().append(append);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public TableName tableName() {
        return this.tableName;
    }

    public Result increment(Increment increment) {
        try {
            return this.table().increment(increment);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result get(Get get) {
        try {
            return this.table().get(get);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result[] get(List<Get> gets) {
        try {
            return this.table().get(gets);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void put(Put put) {
        try {
            this.table().put(put);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void put(List<Put> puts) {
        try {
            this.table().put(puts);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void delete(Delete delete) {
        try {
            this.table().delete(delete);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void delete(List<Delete> deletes) {
        try {
            this.table().delete(deletes);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public ResultScanner scan(Scan scan) {
        try {
            return this.table().getScanner(scan);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void batch(List<? extends Row> actions, Object[] results) {
        try {
            this.table().batch(actions, results);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) {
        try {
            this.table().batchCallback(actions, results, callback);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Async async() {
        return this.async;
    }

    public Fast fast() {
        return this.fast;
    }

    public class Model {
        public <R extends HTableModel> R append(Append append) {
            try {
                return this.convert(HBaseTable.this.table().append(append));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        private <R extends HTableModel> R convert(Result result) {
            return HTableModel.newWrappedModel(HBaseTable.this.tableName, result);
        }

        public <R extends HTableModel> R increment(Increment increment) {
            try {
                return this.convert(HBaseTable.this.table().increment(increment));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public <R extends HTableModel> R get(Get get) {
            try {
                return this.convert(HBaseTable.this.table().get(get));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public <R extends HTableModel> List<R> get(List<Get> gets) {
            try {
                return Arrays.asList(HBaseTable.this.table().get(gets)).stream().collect(ArrayList::new, (list, get) -> list.add(this.convert((Result)get)), (list1, list2) -> list1.addAll(list2));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public ReturnScanner scan(Scan scan) {
            try {
                return new ReturnScanner(HBaseTable.this.table().getScanner(scan));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public class ReturnScanner {
            private ResultScanner scanner;

            public ReturnScanner(ResultScanner scanner) {
                this.scanner = scanner;
            }

            public <R extends HTableModel> R next() throws IOException {
                return this.convert(this.scanner.next());
            }

            private <R extends HTableModel> R convert(Result result) {
                return HTableModel.newWrappedModel(HBaseTable.this.tableName, result);
            }

            public <R extends HTableModel> List<R> next(int nbRows) throws IOException {
                return Arrays.asList(this.scanner.next(nbRows)).stream().collect(ArrayList::new, (list, get) -> list.add(this.convert((Result)get)), (list1, list2) -> list1.addAll(list2));
            }

            public void close() {
                this.scanner.close();
            }

            public <R extends HTableModel> void forEach(Consumer<? super R> action) {
                this.scanner.forEach(result -> action.accept((Object)this.convert((Result)result)));
            }
        }
    }

    public static class Async {
        private TableName tableName;
        private ConcurrentHashMap<TableName, LinkedBlockingQueue<AsyncPackage>> asyncPackages;

        public Async(TableName tableName, ConcurrentHashMap<TableName, LinkedBlockingQueue<AsyncPackage>> asyncPackages) {
            this.tableName = tableName;
            this.asyncPackages = asyncPackages;
        }

        public void get(Get get, ResultTask callback) {
            this.packages(this.tableName).offer(new AsyncPackage((Row)get, callback));
        }

        private LinkedBlockingQueue<AsyncPackage> packages(TableName tableName) {
            if (!this.asyncPackages.containsKey(tableName)) {
                this.asyncPackages.put(tableName, new LinkedBlockingQueue());
            }
            return this.asyncPackages.get(tableName);
        }

        public void append(Append append, ResultTask callback) {
            this.packages(this.tableName).offer(new AsyncPackage((Row)append, callback));
        }

        public void increment(Increment increment, ResultTask callback) {
            this.packages(this.tableName).offer(new AsyncPackage((Row)increment, callback));
        }

        public void put(Put put, CallbackTask callback) {
            this.packages(this.tableName).offer(new AsyncPackage((Row)put, callback));
        }

        public void delete(Delete delete, CallbackTask callback) {
            this.packages(this.tableName).offer(new AsyncPackage((Row)delete, callback));
        }

        public void batch(List<Row> rows, ResultTask task) {
            rows.parallelStream().forEach(row -> this.packages(this.tableName).offer(new AsyncPackage((Row)row, task)));
        }

        public class AsyncPackage {
            protected Row action;
            protected Task callback;

            public AsyncPackage(Row action, Task callback) {
                this.action = action;
                this.callback = callback;
            }
        }
    }

    public static class Fast {
        private TableName tableName;
        private ConcurrentHashMap<TableName, LinkedBlockingQueue<Row>> fastCollection;

        public Fast(TableName tableName, ConcurrentHashMap<TableName, LinkedBlockingQueue<Row>> fastCollection) {
            this.tableName = tableName;
            this.fastCollection = fastCollection;
        }

        public void go(Row action) {
            this.rows(this.tableName).offer(action);
        }

        private LinkedBlockingQueue<Row> rows(TableName tableName) {
            if (!this.fastCollection.containsKey(tableName)) {
                this.fastCollection.put(tableName, new LinkedBlockingQueue());
            }
            return this.fastCollection.get(tableName);
        }

        public void go(List<Row> actions) {
            this.rows(this.tableName).addAll(actions);
        }
    }

    public static interface CallbackTask
    extends Task {
        public void callback();
    }

    public static interface ResultTask
    extends Task {
        public void callback(Result var1);
    }

    public static interface Task {
    }
}

