/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.yetiz.utils.hbase.utils.CallbackTask;
import org.yetiz.utils.hbase.utils.ResultTask;
import org.yetiz.utils.hbase.utils.Task;

public class HAsyncTable {
    private LinkedBlockingQueue<AsyncPackage> asyncQueue;

    public HAsyncTable(LinkedBlockingQueue<AsyncPackage> asyncQueue) {
        this.asyncQueue = asyncQueue;
    }

    public void get(Get get, ResultTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)get, callback));
    }

    public void append(Append append, ResultTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)append, callback));
    }

    public void increment(Increment increment, ResultTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)increment, callback));
    }

    public void put(Put put, CallbackTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)put, callback));
    }

    public void delete(Delete delete, CallbackTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)delete, callback));
    }

    public void batch(List<Row> rows, ResultTask task) {
        for (Row row : rows) {
            this.asyncQueue.offer(new AsyncPackage(row, task));
        }
    }

    public class AsyncPackage {
        protected Row action;
        protected Task callback;

        public AsyncPackage(Row action, Task callback) {
            this.action = action;
            this.callback = callback;
        }
    }
}

