/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yetiz.utils.hbase.Family;
import org.yetiz.utils.hbase.HBaseClient;
import org.yetiz.utils.hbase.HBaseTable;
import org.yetiz.utils.hbase.Qualifier;
import org.yetiz.utils.hbase.TableName;
import org.yetiz.utils.hbase.exception.InvalidOperationException;
import org.yetiz.utils.hbase.exception.TypeNotFoundException;
import org.yetiz.utils.hbase.utils.ModelCallbackTask;

public abstract class HTableModel<T extends HTableModel> {
    protected static final ObjectMapper JSON_MAPPER = new ObjectMapper(new JsonFactory());
    private static final HashMap<TableName, HashMap<String, Qualifier>> ModelQualifiers = new HashMap();
    private static final HashMap<TableName, HashMap<String, Family>> ModelFamilies = new HashMap();
    private static final HashMap<Class<? extends HTableModel>, TableName> ModelTableNameMaps = new HashMap();
    private static final HashMap<TableName, Class<? extends HTableModel>> TableNameModelMaps = new HashMap();
    private static final HashMap<TableName, HashMap<String, String>> ModelFQFields = new HashMap();
    private static final Reflections REFLECTION = new Reflections("", new Scanner[0]);
    private static final ValueSetterPackage DEFAULT_VALUE_SETTER_PACKAGE = new ValueSetterPackage("", "", null);
    private static Field resultField;
    private static Field isResultField;
    private static Logger LOGGER;
    private final HashMap<String, ValueSetterPackage> setValues = new HashMap();
    private boolean isResult = false;
    private Result result = null;
    private boolean copy = false;

    public static final Map<String, Qualifier> qualifiers(TableName tableName) {
        return UnmodifiableMap.decorate((Map)ModelQualifiers.get(tableName));
    }

    public static final Map<String, Family> families(TableName tableName) {
        return UnmodifiableMap.decorate((Map)ModelFamilies.get(tableName));
    }

    public static final TableName tableName(Class<? extends HTableModel> type) {
        return ModelTableNameMaps.get(type);
    }

    public static final Class<? extends HTableModel> modelType(TableName tableName) {
        return TableNameModelMaps.get(tableName);
    }

    public static final <R extends HTableModel> R newWrappedModel(TableName tableName, Result result) {
        try {
            HTableModel r = TableNameModelMaps.get(tableName).newInstance();
            resultField.set(r, result);
            isResultField.set(r, true);
            return (R)r;
        }
        catch (Throwable throwable) {
            throw new TypeNotFoundException(throwable);
        }
    }

    public static final void DBDrop(HBaseClient client) {
        for (Class<HTableModel> type : HTableModel.implementedModels()) {
            try {
                type.newInstance().drop(client);
            }
            catch (Throwable throwable) {}
        }
    }

    private static final List<Class<? extends HTableModel>> implementedModels() {
        Set reflects = REFLECTION.getSubTypesOf(HTableModel.class);
        ArrayList<Class> abstracts = new ArrayList<Class>();
        for (Class type : reflects) {
            if (!Modifier.isAbstract(type.getModifiers())) continue;
            abstracts.add(type);
        }
        reflects.removeAll(abstracts);
        return new ArrayList<Class<? extends HTableModel>>(reflects);
    }

    public void drop(HBaseClient client) {
        client.admin().deleteTable(this.tableName());
    }

    public TableName tableName() {
        return ModelTableNameMaps.get(this.getClass());
    }

    public static final void DBMigration(HBaseClient client) {
        LOGGER.info("Start migration.");
        for (Class<HTableModel> type : HTableModel.implementedModels()) {
            try {
                type.newInstance().migrate(client);
            }
            catch (Throwable throwable) {}
        }
        LOGGER.info("Migration done.");
    }

    /*
     * WARNING - void declaration
     */
    public void migrate(HBaseClient client) {
        if (!client.admin().tableExists(this.tableName())) {
            client.admin().createTable(this.tableName());
        }
        LOGGER.info(String.format("%s migrating...", this.tableName().get().getNameAsString()));
        ObjectNode root = JSON_MAPPER.createObjectNode();
        root.put("object_name", this.getClass().getName());
        HTableDescriptor descriptor = client.admin().tableDescriptor(this.tableName());
        ArrayNode families = JSON_MAPPER.createArrayNode();
        HTableDescriptor finalDescriptor = descriptor;
        HashMap<String, ArrayNode> familyMaps = new HashMap<String, ArrayNode>();
        HashMap<String, String> familyComp = new HashMap<String, String>();
        for (Map.Entry<String, Family> entry : ModelFamilies.get(this.tableName()).entrySet()) {
            void var10_10;
            ArrayNode arrayNode = (ArrayNode)familyMaps.get(entry.getValue().family());
            if (arrayNode == null) {
                ArrayNode arrayNode2 = JSON_MAPPER.createArrayNode();
            }
            familyMaps.put(entry.getValue().family(), var10_10.add((JsonNode)JSON_MAPPER.createObjectNode().put("field_name", entry.getKey()).put("qualifier", ModelQualifiers.get(this.tableName()).get(entry.getKey()).qualifier()).put("description", ModelQualifiers.get(this.tableName()).get(entry.getKey()).description())));
            familyComp.put(entry.getValue().family(), entry.getValue().compression().getName());
        }
        HashMap<String, Family> collect = new HashMap<String, Family>();
        for (Map.Entry<String, Family> entry : ModelFamilies.get(this.tableName()).entrySet()) {
            if (collect.containsKey(entry.getValue().family())) continue;
            collect.put(entry.getValue().family(), entry.getValue());
        }
        for (Map.Entry<String, Family> entry : collect.entrySet()) {
            if (finalDescriptor.hasFamily(HBaseClient.bytes(entry.getKey()))) continue;
            client.admin().addColumnFamily(this.tableName(), entry.getValue().family(), entry.getValue().compression());
        }
        for (Map.Entry<String, Family> entry : familyMaps.entrySet()) {
            families.add(JSON_MAPPER.createObjectNode().put("family", entry.getKey()).put("compression", (String)familyComp.get(entry.getKey())).set("qualifiers", (JsonNode)entry.getValue()));
        }
        root.set("families", (JsonNode)families);
        descriptor = client.admin().tableDescriptor(this.tableName());
        descriptor.setValue("description".getBytes(), root.toString().getBytes());
        client.admin().updateTable(this.tableName(), descriptor);
    }

    private static void initModelQualifier() {
        for (Class<HTableModel> type : HTableModel.implementedModels()) {
            try {
                TableName tableName2 = TableName.valueOf(type.getSimpleName());
                ModelTableNameMaps.put(type, tableName2);
                TableNameModelMaps.put(tableName2, type);
            }
            catch (Throwable tableName2) {}
        }
        for (Class<HTableModel> type : HTableModel.implementedModels()) {
            try {
                try {
                    TableName tableName = type.newInstance().tableName();
                    List<Method> methods = HTableModel.methods(type, null);
                    HashMap<String, String> fqFields = new HashMap<String, String>();
                    for (Method method : methods) {
                        if (method.getAnnotation(Family.class) == null || method.getAnnotation(Qualifier.class) == null) continue;
                        fqFields.put(method.getAnnotation(Family.class).family() + "+-" + method.getAnnotation(Qualifier.class).qualifier(), method.getName());
                    }
                    ModelFQFields.put(tableName, fqFields);
                    HashMap<String, Qualifier> mqs = new HashMap<String, Qualifier>();
                    for (Method method3 : methods) {
                        if (method3.getAnnotation(Qualifier.class) == null) continue;
                        mqs.put(method3.getName(), method3.getAnnotation(Qualifier.class));
                    }
                    ModelQualifiers.put(tableName, mqs);
                    HashMap<String, Family> hashMap = new HashMap<String, Family>();
                    for (Method method4 : methods) {
                        if (method4.getAnnotation(Family.class) == null) continue;
                        hashMap.put(method4.getName(), method4.getAnnotation(Family.class));
                    }
                    ModelFamilies.put(tableName, hashMap);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static final List<Field> fields(Class type, List<Field> fields) {
        if (fields == null) {
            fields = new ArrayList<Field>();
        }
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = HTableModel.fields(type.getSuperclass(), fields);
        }
        return fields;
    }

    private static final List<Method> methods(Class type, List<Method> methods) {
        if (methods == null) {
            methods = new ArrayList<Method>();
        }
        methods.addAll(Arrays.asList(type.getDeclaredMethods()));
        if (type.getSuperclass() != null) {
            methods = HTableModel.methods(type.getSuperclass(), methods);
        }
        return methods;
    }

    public static Get get(byte[] row) {
        Get get = new Get(row);
        return get;
    }

    public static Delete delete(byte[] row) {
        Delete delete = new Delete(row);
        return delete;
    }

    public static final byte[] byteValueFromHex(String hex) {
        return DatatypeConverter.parseHexBinary((String)hex);
    }

    public static final String hexValue(byte[] value) {
        return DatatypeConverter.printHexBinary((byte[])value);
    }

    public T put(HBaseClient client) {
        if (!this.isResult) {
            throw new InvalidOperationException("this is not result instance.");
        }
        Put put = this.put(this.result.getRow());
        HBaseTable table = client.table(this.tableName());
        table.put(put);
        table.close();
        return (T)this;
    }

    public Put put(byte[] row) {
        Put put = new Put(row);
        if (!this.setValues.containsKey("row_updated_time")) {
            this.row_updated_time(System.currentTimeMillis());
        }
        for (ValueSetterPackage pack : this.setValues.values()) {
            put.add(HTableModel.byteValue(pack.family), HTableModel.byteValue(pack.qualifier), pack.value);
        }
        return put;
    }

    @Family(family="d")
    @Qualifier(qualifier="rowudt", description="row-updated-time")
    public T row_updated_time(long updated_time) {
        return this.setValue(updated_time);
    }

    protected final T setValue(long longValue) {
        this.copyResultToSetter();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.setValues.put(methodName, new ValueSetterPackage(this.family(methodName), this.qualifier(methodName), HTableModel.byteValue(longValue)));
        return (T)this;
    }

    private void copyResultToSetter() {
        if (!this.isResult) {
            return;
        }
        if (this.copy) {
            return;
        }
        this.copy = true;
        for (Cell cell : this.result.listCells()) {
            String family = HTableModel.stringValue(CellUtil.cloneFamily((Cell)cell));
            String qualifier = HTableModel.stringValue(CellUtil.cloneQualifier((Cell)cell));
            String methodName = ModelFQFields.get(this.tableName()).get(family + "+-" + qualifier);
            if (methodName == null) continue;
            this.setValues.put(methodName, new ValueSetterPackage(family, qualifier, CellUtil.cloneValue((Cell)cell)));
        }
    }

    public static final String stringValue(byte[] bytes) {
        return new String(bytes, HBaseClient.DEFAULT_CHARSET);
    }

    private final String family(String methodName) {
        return ModelFamilies.get(this.tableName()).get(methodName).family();
    }

    private final String qualifier(String methodName) {
        return ModelQualifiers.get(this.tableName()).get(methodName).qualifier();
    }

    public static final byte[] byteValue(Object object) {
        if (object instanceof CharSequence) {
            return object.toString().getBytes(HBaseClient.DEFAULT_CHARSET);
        }
        if (object instanceof String) {
            return ((String)object).getBytes(HBaseClient.DEFAULT_CHARSET);
        }
        if (object instanceof Long) {
            return ByteBuffer.allocate(8).putLong((Long)object).array();
        }
        if (object instanceof Integer) {
            return ByteBuffer.allocate(4).putInt((Integer)object).array();
        }
        if (object instanceof Float) {
            return ByteBuffer.allocate(4).putFloat(((Float)object).floatValue()).array();
        }
        if (object instanceof Double) {
            return ByteBuffer.allocate(8).putDouble((Double)object).array();
        }
        return object.toString().getBytes(HBaseClient.DEFAULT_CHARSET);
    }

    public T orThen(ModelCallbackTask<T> task) {
        if (this.isEmpty() && this.isResult) {
            task.callback(this);
        }
        return (T)this;
    }

    public boolean isEmpty() {
        return this.result == null || this.result.isEmpty();
    }

    public T then(ModelCallbackTask<T> task) {
        task.callback(this);
        return (T)this;
    }

    public T delete(HBaseClient client) {
        if (!this.isResult) {
            throw new InvalidOperationException("this is not result instance.");
        }
        HBaseTable table = client.table(this.tableName());
        table.delete(new Delete(this.result.getRow()));
        table.close();
        return (T)this;
    }

    public Delete delete() {
        if (!this.isResult) {
            throw new InvalidOperationException("this is not result instance.");
        }
        return new Delete(this.result.getRow());
    }

    public final byte[] row() {
        return this.result.getRow();
    }

    protected final T setValue(String string) {
        this.copyResultToSetter();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.setValues.put(methodName, new ValueSetterPackage(this.family(methodName), this.qualifier(methodName), HTableModel.byteValue(string)));
        return (T)this;
    }

    public Long row_updated_time() {
        return HTableModel.longValue(this.retrieveValue());
    }

    public static final Long longValue(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    protected final byte[] retrieveValue() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        if (this.isResult && !this.copy) {
            return this.result.getValue(HBaseClient.bytes(this.family(methodName)), HBaseClient.bytes(this.qualifier(methodName)));
        }
        ValueSetterPackage valueSetterPackage = this.setValues.get(methodName);
        if (valueSetterPackage == null) {
            valueSetterPackage = DEFAULT_VALUE_SETTER_PACKAGE;
        }
        return valueSetterPackage.value;
    }

    static {
        LOGGER = LoggerFactory.getLogger(HTableModel.class);
        HTableModel.initModelQualifier();
        try {
            resultField = HTableModel.class.getDeclaredField("result");
            isResultField = HTableModel.class.getDeclaredField("isResult");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class ValueSetterPackage {
        public String family;
        public String qualifier;
        public byte[] value;

        public ValueSetterPackage(String family, String qualifier, byte[] value) {
            this.family = family;
            this.qualifier = qualifier;
            this.value = value;
        }
    }
}

