/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.yetiz.utils.hbase.HBaseClient;
import org.yetiz.utils.hbase.TableName;
import org.yetiz.utils.hbase.exception.CatcherRaiseException;
import org.yetiz.utils.hbase.exception.DuplicateException;
import org.yetiz.utils.hbase.exception.NotSupportException;
import org.yetiz.utils.hbase.exception.UnHandledException;
import org.yetiz.utils.hbase.exception.YHBaseException;

public class HBaseAdmin {
    private org.apache.hadoop.hbase.client.HBaseAdmin admin;

    protected HBaseAdmin(org.apache.hadoop.hbase.client.HBaseAdmin admin) {
        this.admin = admin;
    }

    public boolean tableExists(TableName tableName) {
        try {
            this.checkTableNotExist(tableName);
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private void checkTableNotExist(final TableName tableName) {
        this.CATCHER(new Runnable(){

            @Override
            public void run() {
                try {
                    if (HBaseAdmin.this.admin().tableExists(tableName.get())) {
                        throw new DuplicateException("table name existed");
                    }
                }
                catch (Throwable throwable) {
                    throw new UnHandledException(throwable);
                }
            }
        });
    }

    private org.apache.hadoop.hbase.client.HBaseAdmin admin() {
        return this.admin;
    }

    private final void CATCHER(Runnable task) {
        try {
            task.run();
        }
        catch (YHBaseException d) {
            throw d;
        }
        catch (Throwable t) {
            throw new CatcherRaiseException(t);
        }
    }

    public void snapshot(String snapshotName, TableName tableName) {
        try {
            this.admin().snapshot(snapshotName, tableName.get());
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void restoreSnapshot(String snapshotName) {
        try {
            this.admin().restoreSnapshot(snapshotName);
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void close() {
        try {
            this.admin().close();
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) {
        try {
            this.admin().cloneSnapshot(snapshotName, tableName.get());
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() {
        try {
            return this.admin().listSnapshots();
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void deleteSnapshot(String snapshotName) {
        try {
            this.admin().deleteSnapshot(snapshotName);
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public HTableDescriptor tableDescriptor(TableName tableName) {
        try {
            return this.admin().getTableDescriptor(tableName.get());
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void updateTable(TableName tableName, HTableDescriptor tableDescriptor) {
        try {
            this.admin().modifyTable(tableName.get(), tableDescriptor);
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public HTableDescriptor[] listTables() {
        try {
            return this.admin().listTables();
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void enableTable(TableName tableName) {
        if (!this.isTableDisabled(tableName)) {
            return;
        }
        try {
            this.admin().enableTable(tableName.get());
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public boolean isTableDisabled(TableName tableName) {
        try {
            return this.admin().isTableDisabled(tableName.get());
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void truncateTable(TableName tableName) {
        this.truncateTable(tableName, false);
    }

    public void truncateTable(TableName tableName, boolean preserveSplit) {
        throw new NotSupportException();
    }

    public void disableTable(TableName tableName) {
        if (!this.isTableDisabled(tableName)) {
            try {
                this.admin().disableTable(tableName.get());
            }
            catch (Throwable throwable) {
                throw new UnHandledException(throwable);
            }
        }
    }

    public void deleteTable(TableName tableName) {
        this.disableTable(tableName);
        try {
            this.admin().deleteTable(tableName.get());
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void updateCompression(TableName tableName, String family, Compression.Algorithm compression) {
        try {
            this.admin().modifyColumn(tableName.get(), new HColumnDescriptor(family).setCompressionType(compression));
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void addColumnFamily(TableName tableName, String family, Compression.Algorithm compression) {
        try {
            this.admin().addColumn(tableName.get(), new HColumnDescriptor(family).setCompressionType(compression));
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void deleteColumnFamily(TableName tableName, String family) {
        try {
            this.admin().deleteColumn(tableName.get(), HBaseClient.bytes(family));
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void majorCompact(TableName tableName) {
        this.majorCompact(tableName, null);
    }

    public void majorCompact(TableName tableName, String family) {
        try {
            this.admin().majorCompact(tableName.get().getName(), family == null ? null : HBaseClient.bytes(family));
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void split(TableName tableName, byte[] splitPoint) {
        try {
            this.admin().split(tableName.get().getName(), splitPoint);
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public boolean balancer() {
        try {
            return this.admin().balancer();
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void createTable(TableName tableName) {
        this.checkTableNotExist(tableName);
        try {
            this.admin().createTable(this.newTableDescriptor(tableName));
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    private HTableDescriptor newTableDescriptor(TableName tableName) {
        try {
            return new HTableDescriptor(tableName.get());
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }

    public void createTable(TableName tableName, byte[] startKey, byte[] endKey, int numberOfRegions) {
        this.checkTableNotExist(tableName);
        try {
            this.admin().createTable(this.newTableDescriptor(tableName), startKey, endKey, numberOfRegions);
        }
        catch (Throwable throwable) {
            throw new UnHandledException(throwable);
        }
    }
}

