/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.yetiz.utils.hbase.HTableModel;
import org.yetiz.utils.hbase.TableName;
import org.yetiz.utils.hbase.exception.UnHandledException;
import org.yetiz.utils.hbase.exception.YHBaseException;

public class HBaseTable {
    private final HTableInterface table;
    private final TableName tableName;
    private final Model model;
    private boolean closed = false;

    protected HBaseTable(TableName tableName, HTableInterface table) {
        this.tableName = tableName;
        this.table = table;
        this.model = new Model();
    }

    public <R extends HTableModel> Model<R> model() {
        return this.model;
    }

    public void close() {
        try {
            this.table().close();
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
        finally {
            this.closed = true;
        }
    }

    private HTableInterface table() {
        return this.table;
    }

    private YHBaseException convertedException(Throwable throwable) {
        if (throwable instanceof YHBaseException) {
            return (YHBaseException)throwable;
        }
        return new UnHandledException(throwable);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean exists(Get get) {
        try {
            return this.table().exists(get);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public boolean[] exists(List<Get> gets) {
        try {
            Boolean[] tmp = this.table().exists(gets);
            boolean[] rtn = new boolean[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                rtn[i] = tmp[i];
            }
            return rtn;
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result append(Append append) {
        try {
            return this.table().append(append);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public TableName tableName() {
        return this.tableName;
    }

    public Result increment(Increment increment) {
        try {
            return this.table().increment(increment);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result get(Get get) {
        try {
            return this.table().get(get);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result[] get(List<Get> gets) {
        try {
            return this.table().get(gets);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void put(Put put) {
        try {
            this.table().put(put);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void put(List<Put> puts) {
        try {
            this.table().put(puts);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void delete(Delete delete) {
        try {
            this.table().delete(delete);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void delete(List<Delete> deletes) {
        try {
            this.table().delete(deletes);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public ResultScanner scan(Scan scan) {
        try {
            return this.table().getScanner(scan);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void batch(List<? extends Row> actions, Object[] results) {
        try {
            this.table().batch(actions, results);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) {
        try {
            this.table().batchCallback(actions, results, callback);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public class Model<R extends HTableModel> {
        public R append(Append append) {
            try {
                return this.convert(HBaseTable.this.table().append(append));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        private R convert(Result result) {
            return HTableModel.newWrappedModel(HBaseTable.this.tableName, result);
        }

        public R increment(Increment increment) {
            try {
                return this.convert(HBaseTable.this.table().increment(increment));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public R get(Get get) {
            try {
                return this.convert(HBaseTable.this.table().get(get));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public List<R> get(List<Get> gets) {
            try {
                ArrayList<R> rs = new ArrayList<R>();
                for (Result result : Arrays.asList(HBaseTable.this.table().get(gets))) {
                    rs.add(this.convert(result));
                }
                return rs;
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public ReturnScanner<R> scan(Scan scan) {
            try {
                return new ReturnScanner(HBaseTable.this.table().getScanner(scan));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public class ReturnScanner<R extends HTableModel> {
            private ResultScanner scanner;

            public ReturnScanner(ResultScanner scanner) {
                this.scanner = scanner;
            }

            public R next() throws IOException {
                return this.convert(this.scanner.next());
            }

            private R convert(Result result) {
                return HTableModel.newWrappedModel(HBaseTable.this.tableName, result);
            }

            public List<R> next(int nbRows) throws IOException {
                ArrayList<R> rs = new ArrayList<R>();
                for (Result result : Arrays.asList(this.scanner.next(nbRows))) {
                    rs.add(this.convert(result));
                }
                return rs;
            }

            public void close() {
                this.scanner.close();
            }
        }
    }
}

