/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.yetiz.utils.hbase.HTableModel;
import org.yetiz.utils.hbase.TableName;
import org.yetiz.utils.hbase.exception.UnHandledException;
import org.yetiz.utils.hbase.exception.YHBaseException;

public class HBaseTable {
    private final Table table;
    private final TableName tableName;
    private final Model model;

    protected HBaseTable(TableName tableName, Table table) {
        this.tableName = tableName;
        this.table = table;
        this.model = new Model();
    }

    public Model model() {
        return this.model;
    }

    public void close() {
        try {
            this.table().close();
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    private Table table() {
        return this.table;
    }

    private YHBaseException convertedException(Throwable throwable) {
        if (throwable instanceof YHBaseException) {
            return (YHBaseException)throwable;
        }
        return new UnHandledException(throwable);
    }

    public boolean exists(Get get) {
        try {
            return this.table().exists(get);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public boolean[] exists(List<Get> gets) {
        try {
            return this.table().existsAll(gets);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result append(Append append) {
        try {
            return this.table().append(append);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public TableName tableName() {
        return this.tableName;
    }

    public Result increment(Increment increment) {
        try {
            return this.table().increment(increment);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result get(Get get) {
        try {
            return this.table().get(get);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result[] get(List<Get> gets) {
        try {
            return this.table().get(gets);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void put(Put put) {
        try {
            this.table().put(put);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void put(List<Put> puts) {
        try {
            this.table().put(puts);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void delete(Delete delete) {
        try {
            this.table().delete(delete);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void delete(List<Delete> deletes) {
        try {
            this.table().delete(deletes);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public ResultScanner scan(Scan scan) {
        try {
            return this.table().getScanner(scan);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void batch(List<? extends Row> actions, Object[] results) {
        try {
            this.table().batch(actions, results);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) {
        try {
            this.table().batchCallback(actions, results, callback);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public class Model {
        public <R extends HTableModel> R append(Append append) {
            try {
                return this.convert(HBaseTable.this.table().append(append));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        private <R extends HTableModel> R convert(Result result) {
            return HTableModel.newWrappedModel(HBaseTable.this.tableName, result);
        }

        public <R extends HTableModel> R increment(Increment increment) {
            try {
                return this.convert(HBaseTable.this.table().increment(increment));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public <R extends HTableModel> R get(Get get) {
            try {
                return this.convert(HBaseTable.this.table().get(get));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public <R extends HTableModel> List<R> get(List<Get> gets) {
            try {
                return Arrays.asList(HBaseTable.this.table().get(gets)).stream().collect(ArrayList::new, (list, get) -> list.add(this.convert((Result)get)), (list1, list2) -> list1.addAll(list2));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public ReturnScanner scan(Scan scan) {
            try {
                return new ReturnScanner(HBaseTable.this.table().getScanner(scan));
            }
            catch (Throwable throwable) {
                throw HBaseTable.this.convertedException(throwable);
            }
        }

        public class ReturnScanner {
            private ResultScanner scanner;

            public ReturnScanner(ResultScanner scanner) {
                this.scanner = scanner;
            }

            public <R extends HTableModel> R next() throws IOException {
                return this.convert(this.scanner.next());
            }

            private <R extends HTableModel> R convert(Result result) {
                return HTableModel.newWrappedModel(HBaseTable.this.tableName, result);
            }

            public <R extends HTableModel> List<R> next(int nbRows) throws IOException {
                return Arrays.asList(this.scanner.next(nbRows)).stream().collect(ArrayList::new, (list, get) -> list.add(this.convert((Result)get)), (list1, list2) -> list1.addAll(list2));
            }

            public void close() {
                this.scanner.close();
            }

            public <R extends HTableModel> void forEach(Consumer<? super R> action) {
                this.scanner.forEach(result -> action.accept((Object)this.convert((Result)result)));
            }
        }
    }
}

