/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;

public class HAsyncTable {
    private LinkedBlockingQueue<AsyncPackage> asyncQueue;

    public HAsyncTable(LinkedBlockingQueue<AsyncPackage> asyncQueue) {
        this.asyncQueue = asyncQueue;
    }

    public void get(Get get, ResultTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)get, callback));
    }

    public void append(Append append, ResultTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)append, callback));
    }

    public void increment(Increment increment, ResultTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)increment, callback));
    }

    public void put(Put put, CallbackTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)put, callback));
    }

    public void delete(Delete delete, CallbackTask callback) {
        this.asyncQueue.offer(new AsyncPackage((Row)delete, callback));
    }

    public void batch(List<Row> rows, ResultTask task) {
        rows.parallelStream().forEach(row -> this.asyncQueue.offer(new AsyncPackage((Row)row, task)));
    }

    public class AsyncPackage {
        protected Row action;
        protected Task callback;

        public AsyncPackage(Row action, Task callback) {
            this.action = action;
            this.callback = callback;
        }
    }

    public static interface CallbackTask
    extends Task {
        public void callback();
    }

    public static interface ResultTask
    extends Task {
        public void callback(Result var1);
    }

    public static interface Task {
    }
}

