/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yetiz.utils.hbase.Family;
import org.yetiz.utils.hbase.HBaseClient;
import org.yetiz.utils.hbase.Qualifier;
import org.yetiz.utils.hbase.TableName;
import org.yetiz.utils.hbase.exception.InvalidOperationException;
import org.yetiz.utils.hbase.exception.TypeNotFoundException;

public abstract class HTableModel<T extends HTableModel> {
    protected static final ObjectMapper JSON_MAPPER = new ObjectMapper(new JsonFactory());
    private static final HashMap<TableName, HashMap<String, Qualifier>> ModelQualifiers = new HashMap();
    private static final HashMap<TableName, HashMap<String, Family>> ModelFamilies = new HashMap();
    private static final HashMap<Class<? extends HTableModel>, TableName> ModelTableNameMaps = new HashMap();
    private static final HashMap<TableName, Class<? extends HTableModel>> TableNameModelMaps = new HashMap();
    private static final HashMap<TableName, HashMap<String, String>> ModelFQFields = new HashMap();
    private static final Reflections REFLECTION = new Reflections("", new Scanner[0]);
    private static final ValueSetterPackage DEFAULT_VALUE_SETTER_PACKAGE = new ValueSetterPackage("", "", null);
    private static Field resultField;
    private static Field isResultField;
    private static Logger LOGGER;
    private final HashMap<String, ValueSetterPackage> setValues = new HashMap();
    private boolean isResult = false;
    private Result result = null;
    private boolean copy = false;

    public static final TableName tableName(Class<? extends HTableModel> type) {
        return ModelTableNameMaps.get(type);
    }

    public static final Class<? extends HTableModel> modelType(TableName tableName) {
        return TableNameModelMaps.get(tableName);
    }

    public static final <R extends HTableModel> R newWrappedModel(TableName tableName, Result result) {
        try {
            HTableModel r = TableNameModelMaps.get(tableName).newInstance();
            resultField.set(r, result);
            isResultField.set(r, true);
            return (R)r;
        }
        catch (Throwable throwable) {
            throw new TypeNotFoundException(throwable);
        }
    }

    public static final void DBDrop(HBaseClient client) {
        ((Stream)HTableModel.implementedModels().parallel()).forEach(type -> {
            try {
                ((HTableModel)type.newInstance()).drop(client);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private static final Stream<Class<? extends HTableModel>> implementedModels() {
        return REFLECTION.getSubTypesOf(HTableModel.class).stream().filter(type -> !Modifier.isAbstract(type.getModifiers()));
    }

    public void drop(HBaseClient client) {
        client.admin().deleteTable(this.tableName());
    }

    public TableName tableName() {
        return ModelTableNameMaps.get(this.getClass());
    }

    public static final void DBMigration(HBaseClient client) {
        LOGGER.info("Start migration.");
        ((Stream)HTableModel.implementedModels().parallel()).forEach(type -> {
            try {
                ((HTableModel)type.newInstance()).migrate(client);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        LOGGER.info("Migration done.");
    }

    public void migrate(HBaseClient client) {
        if (!client.admin().tableExists(this.tableName())) {
            client.admin().createTable(this.tableName());
        }
        LOGGER.info(String.format("%s migrating...", this.tableName().get().getNameAsString()));
        ObjectNode root = JSON_MAPPER.createObjectNode();
        root.put("object_name", this.getClass().getName());
        HTableDescriptor descriptor = client.admin().tableDescriptor(this.tableName());
        ArrayNode families = JSON_MAPPER.createArrayNode();
        HTableDescriptor finalDescriptor = descriptor;
        HashMap familyMaps = new HashMap();
        HashMap familyComp = new HashMap();
        ModelFamilies.get(this.tableName()).entrySet().stream().map(entry -> {
            familyMaps.put(((Family)entry.getValue()).family(), familyMaps.getOrDefault(((Family)entry.getValue()).family(), JSON_MAPPER.createArrayNode()).add((JsonNode)JSON_MAPPER.createObjectNode().put("field_name", (String)entry.getKey()).put("qualifier", ModelQualifiers.get(this.tableName()).get(entry.getKey()).qualifier()).put("description", ModelQualifiers.get(this.tableName()).get(entry.getKey()).description())));
            familyComp.put(((Family)entry.getValue()).family(), ((Family)entry.getValue()).compression().getName());
            return entry;
        }).collect(HashMap::new, (map, entry) -> {
            if (!map.containsKey(((Family)entry.getValue()).family())) {
                map.put(((Family)entry.getValue()).family(), entry.getValue());
            }
        }, (map1, map2) -> map1.putAll(map2)).entrySet().stream().forEach(entry -> {
            if (!finalDescriptor.hasFamily(HBaseClient.bytes((String)entry.getKey()))) {
                client.admin().addColumnFamily(this.tableName(), ((Family)entry.getValue()).family(), ((Family)entry.getValue()).compression());
            }
        });
        familyMaps.entrySet().stream().forEach(entry -> families.add(JSON_MAPPER.createObjectNode().put("family", (String)entry.getKey()).put("compression", (String)familyComp.get(entry.getKey())).set("qualifiers", (JsonNode)entry.getValue())));
        root.set("families", (JsonNode)families);
        descriptor = client.admin().tableDescriptor(this.tableName());
        descriptor.setValue("description", root.toString());
        client.admin().updateTable(this.tableName(), descriptor);
    }

    private static void initModelQualifier() {
        HTableModel.implementedModels().map(type -> {
            TableName tableName = TableName.valueOf(type.getSimpleName());
            ModelTableNameMaps.put((Class<? extends HTableModel>)type, tableName);
            TableNameModelMaps.put(tableName, (Class<? extends HTableModel>)type);
            return type;
        }).forEach(type -> {
            try {
                TableName tableName = ((HTableModel)type.newInstance()).tableName();
                List<Method> methods = HTableModel.methods(type, null);
                ModelFQFields.put(tableName, methods.stream().collect(HashMap::new, (map, method) -> {
                    if (method.getAnnotation(Family.class) != null && method.getAnnotation(Qualifier.class) != null) {
                        map.put(method.getAnnotation(Family.class).family() + "+-" + method.getAnnotation(Qualifier.class).qualifier(), method.getName());
                    }
                }, (map1, map2) -> map1.putAll(map2)));
                ModelQualifiers.put(tableName, methods.stream().collect(HashMap::new, (map, method) -> {
                    if (method.getAnnotation(Qualifier.class) != null) {
                        map.put(method.getName(), method.getAnnotation(Qualifier.class));
                    }
                }, (map1, map2) -> map1.putAll(map2)));
                ModelFamilies.put(tableName, methods.stream().collect(HashMap::new, (map, method) -> {
                    if (method.getAnnotation(Family.class) != null) {
                        map.put(method.getName(), method.getAnnotation(Family.class));
                    }
                }, (map1, map2) -> map1.putAll(map2)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private static final List<Field> fields(Class type, List<Field> fields) {
        if (fields == null) {
            fields = new ArrayList<Field>();
        }
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = HTableModel.fields(type.getSuperclass(), fields);
        }
        return fields;
    }

    private static final List<Method> methods(Class type, List<Method> methods) {
        if (methods == null) {
            methods = new ArrayList<Method>();
        }
        methods.addAll(Arrays.asList(type.getDeclaredMethods()));
        if (type.getSuperclass() != null) {
            methods = HTableModel.methods(type.getSuperclass(), methods);
        }
        return methods;
    }

    public static Get get(byte[] row) {
        Get get = new Get(row);
        return get;
    }

    public static Delete delete(byte[] row) {
        Delete delete = new Delete(row);
        return delete;
    }

    public boolean isEmpty() {
        return this.result == null || this.result.isEmpty();
    }

    public Put put(byte[] row) {
        Put put = new Put(row);
        if (!this.setValues.containsKey("row_updated_time")) {
            this.row_updated_time(System.currentTimeMillis());
        }
        this.setValues.values().stream().forEach(pack -> put.addColumn(HTableModel.byteValue(pack.family), HTableModel.byteValue(pack.qualifier), pack.value));
        return put;
    }

    public static final byte[] byteValue(String string) {
        return string.getBytes(HBaseClient.DEFAULT_CHARSET);
    }

    @Family(family="d")
    @Qualifier(qualifier="rowudt", description="row-updated-time")
    public T row_updated_time(long updated_time) {
        return this.setValue(updated_time);
    }

    protected final T setValue(long longValue) {
        this.copyResultToSetter();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.setValues.put(methodName, new ValueSetterPackage(this.family(methodName), this.qualifier(methodName), HTableModel.byteValue(longValue)));
        return (T)this;
    }

    private void copyResultToSetter() {
        if (!this.isResult) {
            return;
        }
        if (this.copy) {
            return;
        }
        this.copy = true;
        this.result.listCells().stream().forEach(cell -> {
            String family = HTableModel.stringValue(cell.getFamilyArray());
            String qualifier = HTableModel.stringValue(cell.getQualifierArray());
            String methodName = ModelFQFields.get(this.tableName()).get(family + "+-" + qualifier);
            this.setValues.put(methodName, new ValueSetterPackage(family, qualifier, cell.getValueArray()));
        });
    }

    public static final String stringValue(byte[] bytes) {
        return new String(bytes, HBaseClient.DEFAULT_CHARSET);
    }

    private final String family(String methodName) {
        return ModelFamilies.get(this.tableName()).get(methodName).family();
    }

    private final String qualifier(String methodName) {
        return ModelQualifiers.get(this.tableName()).get(methodName).qualifier();
    }

    public static final byte[] byteValue(long longValue) {
        return ByteBuffer.allocate(8).putLong(longValue).array();
    }

    public Delete delete() {
        if (!this.isResult) {
            throw new InvalidOperationException("this is not result instance.");
        }
        Delete delete = new Delete(this.result.getRow());
        return delete;
    }

    public final byte[] row() {
        return this.result.getRow();
    }

    protected final T setValue(String string) {
        this.copyResultToSetter();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.setValues.put(methodName, new ValueSetterPackage(this.family(methodName), this.qualifier(methodName), HTableModel.byteValue(string)));
        return (T)this;
    }

    public Long row_updated_time() {
        return HTableModel.longValue(this.retrieveValue());
    }

    public static final Long longValue(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    protected final byte[] retrieveValue() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        if (this.isResult && !this.copy) {
            return this.result.getValue(HBaseClient.bytes(this.family(methodName)), HBaseClient.bytes(this.qualifier(methodName)));
        }
        return this.setValues.getOrDefault((Object)methodName, (ValueSetterPackage)HTableModel.DEFAULT_VALUE_SETTER_PACKAGE).value;
    }

    static {
        LOGGER = LoggerFactory.getLogger(HTableModel.class);
        HTableModel.initModelQualifier();
        try {
            resultField = HTableModel.class.getDeclaredField("result");
            isResultField = HTableModel.class.getDeclaredField("isResult");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class ValueSetterPackage {
        public String family;
        public String qualifier;
        public byte[] value;

        public ValueSetterPackage(String family, String qualifier, byte[] value) {
            this.family = family;
            this.qualifier = qualifier;
            this.value = value;
        }
    }
}

