/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yetiz.utils.hbase.HAsyncTable;
import org.yetiz.utils.hbase.HBaseAdmin;
import org.yetiz.utils.hbase.HBaseTable;
import org.yetiz.utils.hbase.HFastTable;
import org.yetiz.utils.hbase.HTableModel;
import org.yetiz.utils.hbase.TableName;
import org.yetiz.utils.hbase.exception.DataSourceException;
import org.yetiz.utils.hbase.exception.UnHandledException;
import org.yetiz.utils.hbase.exception.YHBaseException;
import org.yetiz.utils.hbase.utils.CallbackTask;
import org.yetiz.utils.hbase.utils.ResultTask;
import org.yetiz.utils.hbase.utils.Task;

public final class HBaseClient {
    public static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    private static final int DEFAULT_MAX_FAST_BATCH_COUNT = 5000;
    private static final int DEFAULT_MAX_ASYNC_BATCH_COUNT = 5000;
    private static final ExecutorService EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static final AtomicLong INCREMENT_ID = new AtomicLong(0L);
    protected final HashMap<TableName, LinkedBlockingQueue<Row>> fastCollection = new HashMap();
    protected final HashMap<TableName, LinkedBlockingQueue<HAsyncTable.AsyncPackage>> asyncCollection = new HashMap();
    private final boolean reproducible;
    private final String id = String.format("%s-%d", HBaseClient.class.getName(), INCREMENT_ID.getAndIncrement());
    private final Logger logger = LoggerFactory.getLogger((String)this.id);
    private volatile int fastBatchCount = 4999;
    private volatile int asyncBatchCount = 4999;
    private volatile boolean closed = false;
    private Connection connection;
    private Configuration configuration = HBaseConfiguration.create();

    private HBaseClient(boolean reproducible) {
        this.reproducible = reproducible;
    }

    public static final byte[] bytes(String string) {
        return string.getBytes(DEFAULT_CHARSET);
    }

    public HAsyncTable async(TableName tableName) {
        return new HAsyncTable(this.asyncQueue(tableName));
    }

    public HAsyncTable async(Class<? extends HTableModel> model) {
        return new HAsyncTable(this.asyncQueue(HTableModel.tableName(model)));
    }

    public HFastTable fast(TableName tableName) {
        return new HFastTable(this.fastQueue(tableName));
    }

    public HFastTable fast(Class<? extends HTableModel> model) {
        return new HFastTable(this.fastQueue(HTableModel.tableName(model)));
    }

    public HFastTable fast(HTableModel model) {
        return new HFastTable(this.fastQueue(model.tableName()));
    }

    public int fastBatchCount() {
        return this.fastBatchCount;
    }

    public HBaseClient setFastBatchCount(int fastBatchCount) {
        this.fastBatchCount = fastBatchCount - 1;
        return this;
    }

    public int asyncBatchCount() {
        return this.asyncBatchCount;
    }

    public HBaseClient setAsyncBatchCount(int asyncBatchCount) {
        this.asyncBatchCount = asyncBatchCount - 1;
        return this;
    }

    public HashMap<String, Integer> fastQueueCounts() {
        HashMap<String, Integer> rtn = new HashMap<String, Integer>();
        this.fastCollection.entrySet().forEach(entry -> rtn.put(((TableName)entry.getKey()).get().toString(), ((LinkedBlockingQueue)entry.getValue()).size()));
        return rtn;
    }

    public HashMap<String, Integer> asyncQueueCounts() {
        HashMap<String, Integer> rtn = new HashMap<String, Integer>();
        this.asyncCollection.entrySet().forEach(entry -> rtn.put(((TableName)entry.getKey()).get().toString(), ((LinkedBlockingQueue)entry.getValue()).size()));
        return rtn;
    }

    private void init() {
        this.connection = this.newConnection();
    }

    private Connection newConnection() {
        try {
            Connection connection = ConnectionFactory.createConnection((Configuration)this.configuration);
            return connection;
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
    }

    public HBaseAdmin admin() {
        try {
            return new HBaseAdmin(this.connection.getAdmin());
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
    }

    public void close() {
        this.logger.debug("Close " + this.id());
        this.closed = true;
        try {
            EXECUTOR.shutdown();
            while (!EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logger.debug(this.id() + " Closed");
    }

    private String id() {
        return this.id;
    }

    public boolean closed() {
        return this.closed;
    }

    private void fastLoopTask(TableName tableName, LinkedBlockingQueue<Row> fastQueue, boolean isMaster) {
        ArrayList<Row> rows = new ArrayList<Row>();
        while (!this.closed()) {
            try {
                Row row = fastQueue.poll(1L, TimeUnit.SECONDS);
                if (row == null) {
                    if (isMaster) continue;
                    break;
                }
                rows.add(row);
                if (fastQueue.drainTo(rows, this.fastBatchCount()) == this.fastBatchCount() && this.reproducible) {
                    EXECUTOR.execute(() -> this.fastLoopTask(tableName, fastQueue, false));
                }
                Object[] results = new Object[rows.size()];
                try (HBaseTable table = null;){
                    table = this.table(tableName);
                    table.batch(rows, results);
                }
            }
            catch (Throwable throwable) {
                this.logger.error(throwable.toString());
            }
            if (!isMaster) break;
            rows = new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedBlockingQueue<Row> fastQueue(TableName tableName) {
        if (!this.fastCollection.containsKey(tableName)) {
            HashMap<TableName, LinkedBlockingQueue<Row>> hashMap = this.fastCollection;
            synchronized (hashMap) {
                if (!this.fastCollection.containsKey(tableName)) {
                    LinkedBlockingQueue fastQueue = new LinkedBlockingQueue();
                    this.fastCollection.put(tableName, fastQueue);
                    EXECUTOR.execute(() -> this.fastLoopTask(tableName, fastQueue, true));
                }
            }
        }
        return this.fastCollection.get(tableName);
    }

    private void asyncLoopTask(TableName tableName, LinkedBlockingQueue<HAsyncTable.AsyncPackage> asyncQueue, boolean isMaster) {
        ArrayList<HAsyncTable.AsyncPackage> packages = new ArrayList<HAsyncTable.AsyncPackage>();
        while (!this.closed()) {
            try {
                HAsyncTable.AsyncPackage aPackage = asyncQueue.poll(1L, TimeUnit.SECONDS);
                if (aPackage == null) {
                    if (isMaster) continue;
                    break;
                }
                packages.add(aPackage);
                if (asyncQueue.drainTo(packages, this.asyncBatchCount()) == this.asyncBatchCount() && this.reproducible) {
                    EXECUTOR.execute(() -> this.asyncLoopTask(tableName, asyncQueue, false));
                }
                ArrayList rows = new ArrayList();
                packages.stream().forEach(asyncPackage -> rows.add(asyncPackage.action));
                Object[] results = new Object[packages.size()];
                HAsyncTable.AsyncPackage[] packageArray = new HAsyncTable.AsyncPackage[packages.size()];
                packages.toArray(packageArray);
                try (HBaseTable table = null;){
                    table = this.table(tableName);
                    table.batch(rows, results);
                }
                HashMap<HAsyncTable.AsyncPackage, Object> invokes = new HashMap<HAsyncTable.AsyncPackage, Object>();
                for (int i = 0; i < results.length; ++i) {
                    invokes.put(packageArray[i], results[i]);
                }
                invokes.entrySet().parallelStream().forEach(entry -> {
                    Task task = ((HAsyncTable.AsyncPackage)entry.getKey()).callback;
                    if (task == null) {
                        return;
                    }
                    if (task instanceof ResultTask) {
                        ((ResultTask)task).callback((Result)entry.getValue());
                    }
                    if (task instanceof CallbackTask) {
                        ((CallbackTask)task).callback();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (isMaster) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedBlockingQueue<HAsyncTable.AsyncPackage> asyncQueue(TableName tableName) {
        if (!this.asyncCollection.containsKey(tableName)) {
            HashMap<TableName, LinkedBlockingQueue<HAsyncTable.AsyncPackage>> hashMap = this.asyncCollection;
            synchronized (hashMap) {
                if (!this.asyncCollection.containsKey(tableName)) {
                    LinkedBlockingQueue asyncQueue = new LinkedBlockingQueue();
                    this.asyncCollection.put(tableName, asyncQueue);
                    EXECUTOR.execute(() -> this.asyncLoopTask(tableName, asyncQueue, true));
                }
            }
        }
        return this.asyncCollection.get(tableName);
    }

    public HBaseTable table(HTableModel model) {
        return this.table(model.tableName());
    }

    public HBaseTable table(TableName tableName) {
        try {
            return new HBaseTable(tableName, this.connection().getTable(tableName.get()));
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    protected Connection connection() {
        return this.connection;
    }

    private YHBaseException convertedException(Throwable throwable) {
        if (throwable instanceof YHBaseException) {
            return (YHBaseException)throwable;
        }
        return new UnHandledException(throwable);
    }

    public HBaseTable table(Class<? extends HTableModel> modelClass) {
        return this.table(HTableModel.tableName(modelClass));
    }

    public long rowCount(TableName tableName, byte[] family) {
        AggregationClient aggregationClient = new AggregationClient(this.configuration());
        Scan scan = new Scan();
        scan.addFamily(family);
        long count = 0L;
        try {
            count = aggregationClient.rowCount(tableName.get(), null, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return count;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public static class Builder {
        private HBaseClient hBaseClient;

        public static final Builder create() {
            return Builder.create(true);
        }

        public static final Builder create(boolean reproducible) {
            Builder builder = new Builder();
            builder.hBaseClient = new HBaseClient(reproducible);
            return builder;
        }

        public final Builder configuration(Configuration configuration) {
            this.hBaseClient.configuration = configuration;
            return this;
        }

        public final Builder set(Parameter key, String value) {
            this.hBaseClient.configuration.set(key.name(), value);
            return this;
        }

        public final Builder setLong(Parameter key, Long value) {
            this.hBaseClient.configuration.setLong(key.name(), value.longValue());
            return this;
        }

        public final HBaseClient build() {
            this.hBaseClient.init();
            return this.hBaseClient;
        }
    }

    public static class Parameter {
        public static final Parameter ZK_QUORUM = new Parameter("hbase.zookeeper.quorum");
        public static final Parameter ZK_PROPERTY_CLIENT_PORT = new Parameter("hbase.zookeeper.property.clientPort");
        public static final Parameter CLIENT_SCANNER_CACHING = new Parameter("hbase.client.scanner.caching");
        public static final Parameter RPC_TIMEOUT = new Parameter("hbase.rpc.timeout");
        public static final Parameter ZK_SESSION_TIMEOUT = new Parameter("zookeeper.session.timeout");
        private String name;

        private Parameter(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }
}

