/*
 * Decompiled with CFR 0.152.
 */
package org.yetiz.utils.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.yetiz.utils.hbase.HTableModel;
import org.yetiz.utils.hbase.TableName;
import org.yetiz.utils.hbase.exception.UnHandledException;
import org.yetiz.utils.hbase.exception.YHBaseException;

public class HBaseTable {
    private final Table table;
    private final TableName tableName;
    private final Model model;
    private boolean closed = false;

    protected HBaseTable(TableName tableName, Table table) {
        this.tableName = tableName;
        this.table = table;
        this.model = new Model(table, tableName);
    }

    public <R extends HTableModel> Model<R> model() {
        return this.model;
    }

    public void close() {
        try {
            this.table().close();
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
        finally {
            this.closed = true;
        }
    }

    private Table table() {
        return this.table;
    }

    private YHBaseException convertedException(Throwable throwable) {
        if (throwable instanceof YHBaseException) {
            return (YHBaseException)throwable;
        }
        return new UnHandledException(throwable);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean exists(Get get) {
        try {
            return this.table().exists(get);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public boolean[] exists(List<Get> gets) {
        try {
            return this.table().existsAll(gets);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result append(Append append) {
        try {
            return this.table().append(append);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public TableName tableName() {
        return this.tableName;
    }

    public Result increment(Increment increment) {
        try {
            return this.table().increment(increment);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result get(Get get) {
        try {
            return this.table().get(get);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public Result[] get(List<Get> gets) {
        try {
            return this.table().get(gets);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void put(Put put) {
        try {
            this.table().put(put);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void put(List<Put> puts) {
        try {
            this.table().put(puts);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void delete(Delete delete) {
        try {
            this.table().delete(delete);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void delete(List<Delete> deletes) {
        try {
            this.table().delete(deletes);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public ResultScanner scan(Scan scan) {
        try {
            return this.table().getScanner(scan);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public void batch(List<? extends Row> actions, Object[] results) {
        try {
            this.table().batch(actions, results);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) {
        try {
            this.table().batchCallback(actions, results, callback);
        }
        catch (Throwable throwable) {
            throw this.convertedException(throwable);
        }
    }

    public static class Model<R extends HTableModel> {
        private Table table;
        private TableName tableName;

        public Model(Table table, TableName tableName) {
            this.table = table;
            this.tableName = tableName;
        }

        public void close() throws IOException {
            this.table.close();
        }

        public R append(Append append) {
            try {
                return this.convert(this.table.append(append));
            }
            catch (Throwable throwable) {
                throw this.convertedException(throwable);
            }
        }

        private YHBaseException convertedException(Throwable throwable) {
            if (throwable instanceof YHBaseException) {
                return (YHBaseException)throwable;
            }
            return new UnHandledException(throwable);
        }

        private R convert(Result result) {
            return HTableModel.newWrappedModel(this.tableName, result);
        }

        public R increment(Increment increment) {
            try {
                return this.convert(this.table.increment(increment));
            }
            catch (Throwable throwable) {
                throw this.convertedException(throwable);
            }
        }

        public R get(Get get) {
            try {
                return this.convert(this.table.get(get));
            }
            catch (Throwable throwable) {
                throw this.convertedException(throwable);
            }
        }

        public List<R> get(List<Get> gets) {
            try {
                return Arrays.asList(this.table.get(gets)).stream().collect(ArrayList::new, (list, get) -> list.add(this.convert((Result)get)), (list1, list2) -> list1.addAll(list2));
            }
            catch (Throwable throwable) {
                throw this.convertedException(throwable);
            }
        }

        public ReturnScanner<R> scan(Scan scan) {
            try {
                return new ReturnScanner(this.table.getScanner(scan), this.tableName);
            }
            catch (Throwable throwable) {
                throw this.convertedException(throwable);
            }
        }

        public static class ReturnScanner<R extends HTableModel> {
            private ResultScanner scanner;
            private TableName tableName;

            public ReturnScanner(ResultScanner scanner, TableName tableName) {
                this.scanner = scanner;
                this.tableName = tableName;
            }

            public R next() throws IOException {
                Result result = this.scanner.next();
                if (result == null) {
                    return null;
                }
                return this.convert(result);
            }

            private R convert(Result result) {
                return HTableModel.newWrappedModel(this.tableName, result);
            }

            public List<R> next(int nbRows) throws IOException {
                return Arrays.asList(this.scanner.next(nbRows)).stream().collect(ArrayList::new, (list, get) -> list.add(this.convert((Result)get)), (list1, list2) -> list1.addAll(list2));
            }

            public void close() {
                this.scanner.close();
            }

            public void forEach(Consumer<? super R> action) {
                this.scanner.forEach(result -> action.accept((R)this.convert((Result)result)));
            }
        }
    }
}

