/*
 * Decompiled with CFR 0.152.
 */
package org.yggd.dependencytree.reader;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yggd.dependencytree.reader.LocalRepositoryPomReader;
import org.yggd.dependencytree.reader.PomReader;
import org.yggd.dependencytree.reader.RemoteRepositoryPomReader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\f"}, d2={"Lorg/yggd/dependencytree/reader/CompositePomReader;", "Lorg/yggd/dependencytree/reader/PomReader;", "()V", "pomReaders", "", "[Lorg/yggd/dependencytree/reader/PomReader;", "read", "Ljava/io/InputStream;", "groupId", "", "artifactId", "version", "dependencytree"})
public final class CompositePomReader
implements PomReader {
    @NotNull
    private final PomReader[] pomReaders;

    public CompositePomReader() {
        PomReader[] pomReaderArray = new PomReader[]{new LocalRepositoryPomReader(null, 1, null), new RemoteRepositoryPomReader(null, 1, null)};
        this.pomReaders = pomReaderArray;
    }

    @Override
    @Nullable
    public InputStream read(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        for (PomReader pomReader : this.pomReaders) {
            InputStream i = pomReader.read(groupId, artifactId, version);
            if (i == null) continue;
            return i;
        }
        return null;
    }

    @Override
    @NotNull
    public String replacedGroupId(@NotNull String groupId) {
        return PomReader.DefaultImpls.replacedGroupId(this, groupId);
    }

    @Override
    @NotNull
    public String pomFileName(@NotNull String artifactId, @NotNull String version) {
        return PomReader.DefaultImpls.pomFileName(this, artifactId, version);
    }
}

