/*
 * Decompiled with CFR 0.152.
 */
package org.yggd.dependencytree.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yggd.dependencytree.reader.PomReader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/yggd/dependencytree/reader/LocalRepositoryPomReader;", "Lorg/yggd/dependencytree/reader/PomReader;", "localRepositoryPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "createReader", "Ljava/io/InputStream;", "groupId", "", "artifactId", "version", "read", "dependencytree"})
final class LocalRepositoryPomReader
implements PomReader {
    @NotNull
    private final Path localRepositoryPath;

    public LocalRepositoryPomReader(@NotNull Path localRepositoryPath) {
        Intrinsics.checkNotNullParameter((Object)localRepositoryPath, (String)"localRepositoryPath");
        this.localRepositoryPath = localRepositoryPath;
    }

    public /* synthetic */ LocalRepositoryPomReader(Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String[] stringArray = new String[]{".m2", "repository"};
            Path path2 = Paths.get(System.getProperty("user.home"), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(System.getProperty(\"\u2026e\"), \".m2\", \"repository\")");
            path = path2;
        }
        this(path);
    }

    @Override
    @Nullable
    public InputStream read(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.createReader(groupId, artifactId, version);
    }

    private final InputStream createReader(String groupId, String artifactId, String version) {
        String replacedGroupId = this.replacedGroupId(groupId);
        String pomFileName = this.pomFileName(artifactId, version);
        File pomFile = this.localRepositoryPath.resolve(replacedGroupId).resolve(artifactId).resolve(version).resolve(pomFileName).toFile();
        if (!(pomFile.exists() && pomFile.isFile() && pomFile.canRead())) {
            return null;
        }
        return new FileInputStream(pomFile);
    }

    @Override
    @NotNull
    public String replacedGroupId(@NotNull String groupId) {
        return PomReader.DefaultImpls.replacedGroupId(this, groupId);
    }

    @Override
    @NotNull
    public String pomFileName(@NotNull String artifactId, @NotNull String version) {
        return PomReader.DefaultImpls.pomFileName(this, artifactId, version);
    }

    public LocalRepositoryPomReader() {
        this(null, 1, null);
    }
}

