package org.yggd.client.sftp;

import com.jcraft.jsch.ChannelSftp;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface SftpClient {

    SftpClient connect();
    void ls(String path, Consumer<ChannelSftp.LsEntry> c);
    List<ChannelSftp.LsEntry> lsMatch(String path, Predicate<ChannelSftp.LsEntry> p);

    void put(File f);
    void put(String fileName);
    void put(String fileName, InputStream inputStream);

    InputStream get(String fileName);
    void get(String fileName, OutputStream outputStream);

    void disconnect();
}
