package org.yggd.server;

import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.sshd.server.SshServer;
import org.yggd.server.ftp.FtpEmbeddedServerBuilder;
import org.yggd.server.sftp.SftpEmbeddedServerBuilder;

public class ServerBuilder {

    public static FtpEmbeddedServerBuilder withFtp() {
        return new FtpEmbeddedServerBuilder(new FtpServerFactory(), new ListenerFactory(), new PropertiesUserManagerFactory());
    }

    public static SftpEmbeddedServerBuilder withSftp() {
        return new SftpEmbeddedServerBuilder(SshServer.setUpDefaultServer());
    }
}
