/*
 * Decompiled with CFR 0.152.
 */
package org.yggd.client.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.yggd.client.sftp.SftpClient;

public class SftpClientImpl
implements SftpClient,
AutoCloseable {
    private final Session session;
    private ChannelSftp channelSftp;

    SftpClientImpl(Session session, ChannelSftp channelSftp) {
        this.session = session;
        this.channelSftp = channelSftp;
    }

    @Override
    public SftpClient connect() {
        try {
            this.session.connect();
            this.channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        }
        catch (JSchException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public void ls(String path, Consumer<ChannelSftp.LsEntry> c) {
        try {
            this.channelSftp.ls(path).forEach(e -> c.accept((ChannelSftp.LsEntry)e));
        }
        catch (SftpException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public List<ChannelSftp.LsEntry> lsMatch(String path, Predicate<ChannelSftp.LsEntry> p) {
        ArrayList<ChannelSftp.LsEntry> list = new ArrayList<ChannelSftp.LsEntry>();
        try {
            this.channelSftp.ls(path, entry -> {
                if (p.test(entry)) {
                    list.add(entry);
                }
                return 0;
            });
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
        return list;
    }

    @Override
    public void put(File f) {
        this.put(f.getAbsolutePath());
    }

    @Override
    public void put(String fileName) {
        try {
            this.channelSftp.put(fileName);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void put(String fileName, InputStream inputStream) {
        try {
            this.channelSftp.put(inputStream, fileName);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public InputStream get(String fileName) {
        try {
            return this.channelSftp.get(fileName);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void get(String fileName, OutputStream outputStream) {
        try {
            this.channelSftp.get(fileName, outputStream);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void disconnect() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SftpClientImpl sftpClientImpl = this;
        synchronized (sftpClientImpl) {
            if (this.channelSftp != null) {
                this.channelSftp.disconnect();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        }
    }
}

