/*
 * Decompiled with CFR 0.152.
 */
package org.yggd.server.sftp;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.yggd.server.EmbeddedServer;
import org.yggd.server.EmbeddedServerBuilder;
import org.yggd.server.EmbeddedServerException;

public class SftpEmbeddedServerBuilder
implements EmbeddedServerBuilder {
    private final SshServer sshServer;

    public SftpEmbeddedServerBuilder(SshServer sshServer) {
        this.sshServer = sshServer;
    }

    public SftpEmbeddedServerBuilder port(int port) {
        this.sshServer.setPort(port);
        this.sshServer.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        return this;
    }

    public SftpEmbeddedServerBuilder directory(Path dir) {
        if (!dir.toFile().mkdirs() && !dir.toFile().exists()) {
            throw new EmbeddedServerException("failed create directory:" + dir);
        }
        this.sshServer.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(dir));
        return this;
    }

    public SftpEmbeddedServerBuilder keyPairProvider(String keypairProvider) {
        this.sshServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(Paths.get(keypairProvider, new String[0])));
        return this;
    }

    public SftpEmbeddedServerBuilder passwordAuthenticate(PasswordAuthenticator authenticator) {
        this.sshServer.setPasswordAuthenticator(authenticator);
        return this;
    }

    public SftpEmbeddedServerBuilder publicKeyAuthenticate(File publicKeyFile, InnerAuthenticator authenticator) {
        this.sshServer.setPublickeyAuthenticator((username, key, session) -> authenticator.authenticate(username, key, session, this.publicKey(publicKeyFile)));
        return this;
    }

    private PublicKey publicKey(File publicKeyFile) {
        try {
            List<String> lines = Files.readAllLines(publicKeyFile.toPath());
            if (lines.size() != 1) {
                throw new EmbeddedServerException("publicKey must include single key entry.");
            }
            String[] splitKeys = lines.iterator().next().split(" ");
            if (splitKeys.length < 2) {
                throw new EmbeddedServerException("invalid publicKey format, split more than 2 word by space.");
            }
            String algorithm = splitKeys[0];
            if (!"ssh-rsa".equals(algorithm)) {
                throw new EmbeddedServerException("support only RSA publicKey type.");
            }
            String base64Key = splitKeys[1];
            if (!base64Key.startsWith("AAAA")) {
                throw new EmbeddedServerException("invalid publicKey character array, must start with AAAA.");
            }
            ByteBuffer keyBuf = ByteBuffer.wrap(Base64.getDecoder().decode(base64Key));
            String decodedAlgorithm = this.decodeAlgorithm(keyBuf);
            if (!algorithm.equals(decodedAlgorithm)) {
                throw new EmbeddedServerException("algorithm mismatched between public key header(" + algorithm + ") and decoded raw key(" + decodedAlgorithm + ").");
            }
            BigInteger exponent = this.decodeBigInt(keyBuf);
            BigInteger modulus = this.decodeBigInt(keyBuf);
            return KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new EmbeddedServerException(e);
        }
    }

    private String decodeAlgorithm(ByteBuffer bb) {
        int len = this.decodeInt(bb);
        byte[] raw = new byte[len];
        bb.get(raw);
        return new String(raw, 0, len);
    }

    private int decodeInt(ByteBuffer bb) {
        return bb.getInt();
    }

    private BigInteger decodeBigInt(ByteBuffer bb) {
        int len = bb.getInt();
        byte[] bytes = new byte[len];
        bb.get(bytes);
        return new BigInteger(bytes);
    }

    public EmbeddedServer build() {
        return new SshEmbeddedServer(this.sshServer);
    }

    private static class SshEmbeddedServer
    implements EmbeddedServer {
        private final SshServer sshServer;

        private SshEmbeddedServer(SshServer sshServer) {
            this.sshServer = sshServer;
        }

        @Override
        public void start() {
            try {
                this.sshServer.start();
            }
            catch (IOException e) {
                throw new EmbeddedServerException(e);
            }
        }

        @Override
        public void stop() {
            try {
                this.sshServer.stop();
            }
            catch (IOException e) {
                throw new EmbeddedServerException(e);
            }
        }

        @Override
        public boolean isRunning() {
            return this.sshServer.isStarted();
        }
    }

    @FunctionalInterface
    public static interface InnerAuthenticator {
        public boolean authenticate(String var1, PublicKey var2, ServerSession var3, PublicKey var4);
    }
}

