/*
 * Decompiled with CFR 0.152.
 */
package org.yggd.client.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yggd.client.tcp.TcpClient;

public class TcpClientImpl
implements TcpClient {
    private final Bootstrap bootStrap = new Bootstrap();
    private final EventLoopGroup group = new NioEventLoopGroup();
    private int timeout = -1;

    @Override
    public TcpClient connect(String host, int port) {
        ((Bootstrap)((Bootstrap)this.bootStrap.group(this.group)).channel(NioSocketChannel.class)).remoteAddress((SocketAddress)new InetSocketAddress(host, port));
        return this;
    }

    @Override
    public TcpClient timeout(long timeout, TimeUnit timeUnit) {
        if (timeout > 0L) {
            this.timeout = (int)timeUnit.toSeconds(timeout);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] exchange(byte[] buf) {
        final InboundHandler inboundHandler = new InboundHandler(buf);
        this.bootStrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                if (TcpClientImpl.this.timeout > 0) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ReadTimeoutHandler(TcpClientImpl.this.timeout)});
                }
                ch.pipeline().addLast(new ChannelHandler[]{inboundHandler});
            }
        });
        try {
            ChannelFuture channelFuture = this.bootStrap.connect().sync();
            channelFuture.channel().closeFuture().sync();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                this.group.shutdownGracefully().sync();
            }
            catch (InterruptedException interruptedException) {}
        }
        return inboundHandler.response();
    }

    private static class InboundHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private static final Logger logger = LoggerFactory.getLogger(InboundHandler.class);
        private final ByteBuf request;
        private BlockingQueue<byte[]> responseQueue = new ArrayBlockingQueue<byte[]>(1);

        private InboundHandler(byte[] rawBytes) {
            this.request = Unpooled.copiedBuffer((byte[])rawBytes);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.error("exception cause.", cause);
            ctx.close();
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.responseQueue.clear();
            ctx.writeAndFlush((Object)this.request);
        }

        private byte[] retrieveByteArray(ByteBuf buf) {
            if (buf.hasArray()) {
                return buf.array();
            }
            byte[] heapArray = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), heapArray);
            return heapArray;
        }

        byte[] response() {
            return (byte[])this.responseQueue.poll();
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
            this.responseQueue.put(this.retrieveByteArray(byteBuf));
            channelHandlerContext.close();
        }
    }
}

