/*
 * Decompiled with CFR 0.152.
 */
package org.yggd.server;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.UserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.yggd.server.EmbeddedServer;
import org.yggd.server.EmbeddedServerBuilder;
import org.yggd.server.EmbeddedServerException;

public class FtpEmbeddedServerBuilder
implements EmbeddedServerBuilder {
    private final List<User> users = new ArrayList<User>();
    private final FtpServerFactory ftpServerFactory;
    private final ListenerFactory listenerFactory;
    private final UserManagerFactory userManagerFactory;
    private final List<Authority> authorities = new ArrayList<Authority>();

    FtpEmbeddedServerBuilder(FtpServerFactory ftpServerFactory, ListenerFactory listenerFactory, UserManagerFactory userManagerFactory) {
        this.ftpServerFactory = ftpServerFactory;
        this.listenerFactory = listenerFactory;
        this.userManagerFactory = userManagerFactory;
    }

    public FtpEmbeddedServer build() {
        this.ftpServerFactory.addListener("default", this.listenerFactory.createListener());
        UserManager userManager = this.userManagerFactory.createUserManager();
        this.users.forEach(u -> {
            try {
                userManager.save(u);
            }
            catch (FtpException e) {
                throw new EmbeddedServerException(e);
            }
        });
        this.ftpServerFactory.setUserManager(userManager);
        return new FtpEmbeddedServer(this.ftpServerFactory.createServer());
    }

    public FtpEmbeddedServerBuilder filesystem(Consumer<NativeFileSystemFactory> c) {
        NativeFileSystemFactory fileSystemFactory = new NativeFileSystemFactory();
        c.accept(fileSystemFactory);
        this.ftpServerFactory.setFileSystem((FileSystemFactory)fileSystemFactory);
        return this;
    }

    public FtpEmbeddedServerBuilder port(int port) {
        this.listenerFactory.setPort(port);
        return this;
    }

    public FtpEmbeddedServerBuilder ssl(Consumer<SslConfig> sslConfigConsumer) {
        SslConfig sslConfig = new SslConfig(this.listenerFactory);
        sslConfigConsumer.accept(sslConfig);
        this.listenerFactory.setSslConfiguration(sslConfig.getConfiguration());
        return this;
    }

    public FtpEmbeddedServerBuilder user(Consumer<BaseUser> consumer) {
        return this.user(consumer, false);
    }

    public FtpEmbeddedServerBuilder user(Consumer<BaseUser> consumer, boolean readOnly) {
        BaseUser baseUser = new BaseUser();
        if (!readOnly) {
            baseUser.setAuthorities(Collections.singletonList(new WritePermission()));
        }
        consumer.accept(baseUser);
        this.users.add((User)baseUser);
        return this;
    }

    public static class SslConfig {
        private final SslConfigurationFactory sslConfigurationFactory = new SslConfigurationFactory();
        private final ListenerFactory listenerFactory;

        private SslConfig(ListenerFactory listenerFactory) {
            this.listenerFactory = listenerFactory;
        }

        public void keystoreString(String keystore) {
            this.sslConfigurationFactory.setKeystoreFile(new File(keystore));
        }

        public void keystorePath(Path keystore) {
            this.sslConfigurationFactory.setKeystoreFile(keystore.toFile());
        }

        public void implicit() {
            this.listenerFactory.setImplicitSsl(true);
        }

        public void explicit() {
            this.listenerFactory.setImplicitSsl(false);
        }

        public void keystoreResource(File keystore) {
            this.sslConfigurationFactory.setKeystoreFile(keystore);
        }

        public void keyAlias(String keyAlias) {
            this.sslConfigurationFactory.setKeyAlias(keyAlias);
        }

        public void keystorePassword(String keystorePassword) {
            this.sslConfigurationFactory.setKeystorePassword(keystorePassword);
        }

        public void keyPassword(String keyPassword) {
            this.sslConfigurationFactory.setKeyPassword(keyPassword);
        }

        public void keystoreAlgorithm(String keystoreAlgorithm) {
            this.sslConfigurationFactory.setKeystoreAlgorithm(keystoreAlgorithm);
        }

        public void truststoreFile(File truststoreFile) {
            this.sslConfigurationFactory.setTruststoreFile(truststoreFile);
        }

        public void truststoreType(String truststoreType) {
            this.sslConfigurationFactory.setTruststoreType(truststoreType);
        }

        public void truststorePassword(String truststorePassword) {
            this.sslConfigurationFactory.setTruststorePassword(truststorePassword);
        }

        public void truststoreAlgorithm(String truststoreAlgorithm) {
            this.sslConfigurationFactory.setTruststoreAlgorithm(truststoreAlgorithm);
        }

        public void sslProtocol(String sslProtocol) {
            this.sslConfigurationFactory.setSslProtocol(sslProtocol);
        }

        public void enabledCipherSuites(String[] enabledCipherSuites) {
            this.sslConfigurationFactory.setEnabledCipherSuites(enabledCipherSuites);
        }

        public void clientAuthentication(String clientAuthentication) {
            this.sslConfigurationFactory.setClientAuthentication(clientAuthentication);
        }

        private SslConfiguration getConfiguration() {
            return this.sslConfigurationFactory.createSslConfiguration();
        }
    }

    private static class FtpEmbeddedServer
    implements EmbeddedServer {
        private final FtpServer ftpServer;

        private FtpEmbeddedServer(FtpServer ftpServer) {
            this.ftpServer = ftpServer;
        }

        @Override
        public void start() {
            try {
                this.ftpServer.start();
            }
            catch (FtpException e) {
                throw new EmbeddedServerException(e);
            }
        }

        @Override
        public void stop() {
            this.ftpServer.stop();
        }

        @Override
        public boolean isRunning() {
            return !this.ftpServer.isStopped() && !this.ftpServer.isSuspended();
        }
    }
}

