/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.core;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.tasks.WorkResult;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.ysb33r.grolifant.internal.core.ProjectOperationsLoader;

public interface ProjectOperations {
    public static ProjectOperations maybeCreateExtension(Project project) {
        try {
            return ProjectOperations.find(project);
        }
        catch (UnknownDomainObjectException e) {
            ProjectOperations po = ProjectOperationsLoader.load(project);
            project.getExtensions().add(ProjectOperations.class, "grolifant", (Object)po);
            return po;
        }
    }

    public static ProjectOperations create(Project project) {
        try {
            return ProjectOperations.find(project);
        }
        catch (UnknownDomainObjectException e) {
            return ProjectOperationsLoader.load(project);
        }
    }

    public static ProjectOperations find(Project project) {
        return (ProjectOperations)project.getExtensions().getByType(ProjectOperations.class);
    }

    public ReadableResource bzip2Resource(Object var1);

    public ReadableResource gzipResource(Object var1);

    public CopySpec copySpec();

    public CopySpec copySpec(Action<? super CopySpec> var1);

    public Provider<File> buildDirDescendant(Object var1);

    public WorkResult copy(Action<? super CopySpec> var1);

    public boolean delete(Object ... var1);

    public WorkResult delete(Action<? super DeleteSpec> var1);

    public ExecResult exec(Action<? super ExecSpec> var1);

    public Provider<File> getBuildDir();

    @Deprecated
    public ExtensionContainer getExtensions();

    public Provider<File> getGradleUserHomeDir();

    public Provider<String> getGroupProvider();

    public File getProjectCacheDir();

    public ProviderFactory getProviders();

    public Provider<String> getVersionProvider();

    public File file(Object var1);

    public List<File> fileize(Iterable<Object> var1);

    public FileCollection files(Object ... var1);

    public ConfigurableFileTree fileTree(Object var1);

    public boolean isOffline();

    public boolean isRefreshDependencies();

    public boolean isRerunTasks();

    public ExecResult javaexec(Action<? super JavaExecSpec> var1);

    public <IN, OUT> Provider<OUT> map(Provider<IN> var1, Transformer<OUT, IN> var2);

    public ConsoleOutput getConsoleOutput();

    public LogLevel getGradleLogLevel();

    public <T> Provider<T> provider(Callable<? extends T> var1);

    public String relativePath(Object var1);

    public FileTree tarTree(Object var1);

    public void updateFileProperty(Provider<File> var1, Object var2);

    public void updateStringProperty(Provider<String> var1, Object var2);

    public FileTree zipTree(Object var1);
}

