/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2022
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core;

import org.gradle.api.Project;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.ysb33r.grolifant.api.core.jvm.JvmAppRunnerSpec;
import org.ysb33r.grolifant.internal.core.loaders.JvmToolsLoader;

/**
 * Tools for creating various JVM/Java utility cobjects.
 *
 * @author Schalk W. Cronjé
 * @since 2.0
 */
public interface JvmTools {
    static JvmTools load(ProjectOperations incompleteReference, Project project) {
        return JvmToolsLoader.load(incompleteReference, project);
    }

    /**
     * Creates a {@link JavaExecSpec}.
     *
     * @return Returns something compatible with a {@link JavaExecSpec}.
     */
    JavaExecSpec javaExecSpec();

    /**
     * Creates a {@Link JavaForkOptions}.
     *
     * @return Returns something compatible with a {@link JavaForkOptions}.
     */
    default JavaForkOptions javaForkOptions() {
        return javaExecSpec();
    }

    /**
     * Creates a {@link JvmAppRunnerSpec}.
     *
     * THis is primarily used internally by classes that implements execution specifications on the JVM.
     *
     * @return Implementation of {@link JvmAppRunnerSpec}
     */
    JvmAppRunnerSpec jvmAppRunnerSpec();
}
